/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.log.LogUtil;
import com.simba.server.ServerManager;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.SorterParams;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.components.data.TrashSlotInfo;
import com.simba.server.task.SlotStatusTask;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class SlotManager {
    public static final int NORMAL_SLOT_0 = 0;
    public static final int TRASH_SLOT_1_NO_INFO = 1;
    public static final int TRASH_SLOT_2_NO_PLAN = 2;
    public static final int TRASH_SLOT_3_NO_READ = 3;
    public static final int TRASH_SLOT_4_MULTI_BARCODE = 4;
    public static final int TRASH_SLOT_5_MAX_CIRCLE = 5;
    public static final int TRASH_SLOT_6_LOST_PACKET = 6;
    public static final int TRASH_SLOT_7_OVER_TIME = 7;
    public static final int TRASH_SLOT_8_IBB_ERROR = 8;
    public static final int TRASH_SLOT_9_UNKNOWN_ERROR = 9;
    public static final int TRASH_SLOT_10_SERVER_ERROR = 10;
    private static final Logger logger = Logger.getLogger(SlotManager.class);
    private final List<Integer> ibbErrorTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> invalidCodeTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> lostPackTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> maxCircleTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> multiCodeTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> noInfoTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> noPlanTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> noReadTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> overTimeTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> unknownTrashSlotList = new ArrayList<Integer>();
    private final List<Integer> serverErrorTrashSlotList = new ArrayList<Integer>();
    private final ConcurrentHashMap<String, SlotInfo> slotInfoList = new ConcurrentHashMap();
    private byte[] slotLockStatus;
    private final SlotStatusTask slotStatusTask = new SlotStatusTask();
    private final ConcurrentHashMap<String, SlotInfo> trashSlotList = new ConcurrentHashMap();

    public static SlotManager getInstance() {
        return SlotManagerHolder.INSTANCE;
    }

    private SlotManager() {
    }

    public Boolean checkSlotIsTrash(String slotId) {
        Boolean ret = false;
        if (this.trashSlotList.containsKey(slotId)) {
            ret = true;
        }
        return ret;
    }

    public void doGetTrashSlots(TrashSlotInfo trashSlotInfo) {
        List<Integer> configTrashSlots;
        int trashType = trashSlotInfo.getTypeId();
        ICommand command = CommandCreator.getInstance().createCommand("FetchTrashSlotsCmd", trashSlotInfo);
        Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
        if (ret.booleanValue() && (configTrashSlots = trashSlotInfo.getTrashSlots()) != null && configTrashSlots.size() > 0) {
            switch (trashType) {
                case 1: {
                    this.setNoInfoTrashSlots(configTrashSlots);
                    break;
                }
                case 2: {
                    this.setNoPlanTrashSlots(configTrashSlots);
                    break;
                }
                case 3: {
                    this.setNoReadTrashSlots(configTrashSlots);
                    break;
                }
                case 4: {
                    this.setMultiCodeTrashSlots(configTrashSlots);
                    break;
                }
                case 5: {
                    this.setMaxCircleTrashSlots(configTrashSlots);
                    break;
                }
                case 6: {
                    this.setLostPackTrashSlots(configTrashSlots);
                    break;
                }
                case 7: {
                    this.setOverTimeTrashSlots(configTrashSlots);
                    break;
                }
                case 8: {
                    this.setIBBErrorTrashSlots(configTrashSlots);
                    break;
                }
                case 9: {
                    this.setUnknownErrorTrashSlots(configTrashSlots);
                    break;
                }
                case 10: {
                    this.setServerErrorTrashSlots(configTrashSlots);
                    break;
                }
            }
            this.registerTrashSlot(configTrashSlots);
        }
    }

    public List<Integer> getServerErrorTrashSlots() {
        return this.serverErrorTrashSlotList;
    }

    public List<Integer> getUnknownErrorTrashSlots() {
        return this.unknownTrashSlotList;
    }

    public List<Integer> getInvalidCodeTrashSlots() {
        return this.invalidCodeTrashSlotList;
    }

    public List<Integer> getMultiCodeTrashSlots() {
        return this.multiCodeTrashSlotList;
    }

    public List<Integer> getNoInfoTrashSlots() {
        return this.noInfoTrashSlotList;
    }

    public List<Integer> getNoPlanTrashSlots() {
        return this.noPlanTrashSlotList;
    }

    public List<Integer> getNoReadTrashSlots() {
        return this.noReadTrashSlotList;
    }

    public List<Integer> getOverTimeTrashSlots() {
        return this.overTimeTrashSlotList;
    }

    public SlotInfo getSlotInfo(String key) {
        return this.slotInfoList.get(key.toLowerCase());
    }

    public SlotInfo[] getSlotInfoList() {
        return this.slotInfoList.values().toArray(new SlotInfo[0]);
    }

    public byte[] getSlotLockStatus() {
        return this.slotLockStatus;
    }

    public void init() {
        try {
            int slotSize = SorterParams.getInstance().getSlotNumber();
            this.slotLockStatus = new byte[slotSize];
            for (int i = 0; i < this.slotLockStatus.length; ++i) {
                this.slotLockStatus[i] = 1;
            }
            this.initSlotInfos();
            this.initTrashSlots();
            this.initTasks();
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "init slot info  error: " + ex);
        }
    }

    public void initTrashSlots() {
        this.trashSlotList.clear();
        this.initNoInfoTrashSlot();
        this.initNoPlanTrashSlot();
        this.initNoReadTrashSlot();
        this.initMultiCodeTrashSlot();
        this.initMaxCircleTrashSlot();
        this.initLostPackTrashSlot();
        this.initOverTimeTrashSlot();
        this.initIBBTrashSlot();
        this.initUnknownErrorTrashSlot();
        this.initServerErrorTrashSlot();
    }

    public void postInitProcess() {
    }

    public void registerTrashSlot(List<Integer> configTrashSlots) {
        for (Integer slotValue : configTrashSlots) {
            SlotInfo slotInfo;
            String slotId = String.valueOf(slotValue);
            if (this.trashSlotList.containsKey(slotId) || (slotInfo = this.slotInfoList.get(slotId)) == null) continue;
            this.trashSlotList.put(slotId, slotInfo);
        }
    }

    public void reloadTshSlots() {
        this.initTrashSlots();
    }

    public void sendTshSlotsToPLC() {
        SortProtocolCreator.getInstance().doSendTshSlotsToPLC(this.noInfoTrashSlotList, 1);
        SortProtocolCreator.getInstance().doSendTshSlotsToPLC(this.noPlanTrashSlotList, 2);
        SortProtocolCreator.getInstance().doSendTshSlotsToPLC(this.noReadTrashSlotList, 3);
        SortProtocolCreator.getInstance().doSendTshSlotsToPLC(this.multiCodeTrashSlotList, 4);
        SortProtocolCreator.getInstance().doSendTshSlotsToPLC(this.maxCircleTrashSlotList, 5);
        SortProtocolCreator.getInstance().doSendTshSlotsToPLC(this.lostPackTrashSlotList, 6);
        SortProtocolCreator.getInstance().doSendTshSlotsToPLC(this.overTimeTrashSlotList, 7);
        SortProtocolCreator.getInstance().doSendTshSlotsToPLC(this.ibbErrorTrashSlotList, 8);
        SortProtocolCreator.getInstance().doSendTshSlotsToPLC(this.unknownTrashSlotList, 9);
        SortProtocolCreator.getInstance().doSendTshSlotsToPLC(this.serverErrorTrashSlotList, 10);
    }

    private void initNoInfoTrashSlot() {
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(1);
        this.doGetTrashSlots(trashSlotInfo);
    }

    private void initNoPlanTrashSlot() {
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(2);
        this.doGetTrashSlots(trashSlotInfo);
    }

    private void initNoReadTrashSlot() {
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(3);
        this.doGetTrashSlots(trashSlotInfo);
    }

    private void initMultiCodeTrashSlot() {
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(4);
        this.doGetTrashSlots(trashSlotInfo);
    }

    private void initMaxCircleTrashSlot() {
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(5);
        this.doGetTrashSlots(trashSlotInfo);
    }

    private void initLostPackTrashSlot() {
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(6);
        this.doGetTrashSlots(trashSlotInfo);
    }

    private void initOverTimeTrashSlot() {
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(7);
        this.doGetTrashSlots(trashSlotInfo);
    }

    private void initIBBTrashSlot() {
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(8);
        this.doGetTrashSlots(trashSlotInfo);
    }

    private void initUnknownErrorTrashSlot() {
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(9);
        this.doGetTrashSlots(trashSlotInfo);
    }

    private void initServerErrorTrashSlot() {
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(10);
        this.doGetTrashSlots(trashSlotInfo);
    }

    private void initSlotInfos() {
        this.slotInfoList.clear();
        LinkedList slots = new LinkedList();
        ICommand command = CommandCreator.getInstance().createCommand("FetchSlotInfoCmd", slots);
        Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
        if (ret.booleanValue()) {
            for (SlotInfo slotInfo : slots) {
                slotInfo.resetBoxInfo();
                slotInfo.getBoxInfo().setSlotId(slotInfo.getSlotId());
                slotInfo.getBoxInfo().setChuteCode(slotInfo.getChuteCode());
                this.slotInfoList.put(slotInfo.getSlotId(), slotInfo);
            }
        }
        this.printSlotInfos();
    }

    private void printSlotInfos() {
        String info = "[SlotManager.initSlotInfos] Current slot number : [" + this.slotInfoList.size() + "]";
        LogUtil.LogDebug(logger, info);
    }

    private void initTasks() {
        this.slotStatusTask.start();
    }

    private void setServerErrorTrashSlots(List<Integer> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.ibbErrorTrashSlotList.clear();
        this.ibbErrorTrashSlotList.addAll(configTrashSlots);
    }

    private void setUnknownErrorTrashSlots(List<Integer> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.ibbErrorTrashSlotList.clear();
        this.ibbErrorTrashSlotList.addAll(configTrashSlots);
    }

    private void setIBBErrorTrashSlots(List<Integer> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.ibbErrorTrashSlotList.clear();
        this.ibbErrorTrashSlotList.addAll(configTrashSlots);
    }

    private void setLostPackTrashSlots(List<Integer> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.lostPackTrashSlotList.clear();
        this.lostPackTrashSlotList.addAll(configTrashSlots);
    }

    private void setMaxCircleTrashSlots(List<Integer> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.maxCircleTrashSlotList.clear();
        this.maxCircleTrashSlotList.addAll(configTrashSlots);
    }

    private void setMultiCodeTrashSlots(List<Integer> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.multiCodeTrashSlotList.clear();
        this.multiCodeTrashSlotList.addAll(configTrashSlots);
    }

    private void setNoInfoTrashSlots(List<Integer> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.noInfoTrashSlotList.clear();
        this.noInfoTrashSlotList.addAll(configTrashSlots);
    }

    private void setNoPlanTrashSlots(List<Integer> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.noPlanTrashSlotList.clear();
        this.noPlanTrashSlotList.addAll(configTrashSlots);
    }

    private void setNoReadTrashSlots(List<Integer> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.noReadTrashSlotList.clear();
        this.noReadTrashSlotList.addAll(configTrashSlots);
    }

    private void setOverTimeTrashSlots(List<Integer> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.overTimeTrashSlotList.clear();
        this.overTimeTrashSlotList.addAll(configTrashSlots);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAllocBoxInfo(SlotInfo slotInfo, Channel channel) {
        SlotInfo slotInfo2 = slotInfo;
        synchronized (slotInfo2) {
            if (slotInfo.getAllocBoxInfo().booleanValue()) {
                slotInfo.setLockStatus(0);
                this.setSlotSoftLockStatus(slotInfo);
                this.sendSlotSoftUnLockToPLC(slotInfo, channel);
                return;
            }
            slotInfo.setAllocBoxInfo(true);
            slotInfo.setLockStatus(0);
            this.setSlotSoftLockStatus(slotInfo);
            this.sendSlotSoftUnLockToPLC(slotInfo, channel);
        }
    }

    public void sendSlotSoftUnLockToPLC(SlotInfo slotInfo, Channel channel) {
        try {
            byte[] replyBuffer = SortProtocolCreator.getInstance().createSlotSoftUnLock(Integer.parseInt(slotInfo.getSlotId()));
            Channel tmpChannel = channel;
            FrameChannelManager.getInstance().commitResponse(tmpChannel, replyBuffer, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSlotSoftLockStatus(SlotInfo slotInfo) {
        try {
            int slotIndex = Integer.parseInt(slotInfo.getSlotId()) - 1;
            int softLockStatus = slotInfo.getLockStatus();
            if (this.slotLockStatus == null || this.slotLockStatus.length <= slotIndex) {
                return;
            }
            this.slotLockStatus[slotIndex] = (byte)softLockStatus;
        }
        catch (Exception e) {
            LogUtil.LogError(logger, "Update Slot Soft Lock Status Error.");
        }
    }

    public void sendSlotSoftLockToPLC(SlotInfo slotInfo, Channel channel) {
        try {
            byte[] replyBuffer = SortProtocolCreator.getInstance().createSlotSoftLock(Integer.parseInt(slotInfo.getSlotId()));
            Channel tmpChannel = channel;
            FrameChannelManager.getInstance().commitResponse(tmpChannel, replyBuffer, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void offerSlotPackToRestore(SlotInfo slotInfo) {
        try {
            SlotInfo newSlotInfo = new SlotInfo();
            newSlotInfo.cloneSlotInfo(slotInfo);
            ServerManager.getInstance().getDataRestoreTask().offerRestoreDataToQueue(newSlotInfo);
        }
        catch (Exception e) {
            LogUtil.LogError(logger, "offer slot info to restore: " + e.getMessage());
        }
    }

    private static class SlotManagerHolder {
        private static final SlotManager INSTANCE = new SlotManager();

        private SlotManagerHolder() {
        }
    }
}

