/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.GlobalParam;
import com.simba.common.log.LogUtil;
import com.simba.server.ServerManager;
import com.simba.server.components.PlatInstance;
import com.simba.server.components.data.PacketOnInfo;
import java.io.File;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;

public class PlatManager {
    private static final Logger logger = Logger.getLogger(PlatManager.class);
    private static final ConcurrentHashMap<String, PacketOnInfo> packetOnHashMap = new ConcurrentHashMap();
    private String configFile;
    private String configFilePath;
    private final ConcurrentHashMap<String, PlatInstance> plats = new ConcurrentHashMap();

    public static PlatManager getInstance() {
        return ProvidePlatManagerHolder.INSTANCE;
    }

    private PlatManager() {
    }

    public void addPacketOnInfo(String trayCode, PacketOnInfo packetOnInfo) {
        if (trayCode == null || trayCode.equals("") || packetOnInfo == null) {
            return;
        }
        packetOnHashMap.put(trayCode, packetOnInfo);
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public String getConfigFilePath() {
        return this.configFilePath;
    }

    public PacketOnInfo getPacketOnInfo(String carId) {
        if (carId == null || carId.equals("")) {
            return null;
        }
        return packetOnHashMap.get(carId);
    }

    public PlatInstance getPlatById(String id) {
        PlatInstance plat = null;
        if (this.plats.containsKey(id)) {
            plat = this.plats.get(id);
        }
        return plat;
    }

    public void init(String _configFile) {
        this.setConfigFile(_configFile);
        this.setConfigFilePath("etc" + GlobalParam.PATH_SEP + this.configFile);
        try {
            this.initPlats();
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Init Plat Instance Manager Error -- Exception : " + ex);
        }
    }

    public void postInitProcess() {
        LogUtil.LogDebug(logger, "PlatInstanceManager initialize successfully");
    }

    public PacketOnInfo removePacketOnInfo(String carId) {
        if (carId == null || carId.equals("")) {
            return null;
        }
        return packetOnHashMap.remove(carId);
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void setConfigFilePath(String configFilePath) {
        this.configFilePath = configFilePath;
    }

    private void initPlats() throws Exception {
        Document rootDoc = ServerManager.getInstance().getXmlDocFromFile(new File(this.configFilePath));
        Element root = rootDoc.getRootElement();
        Element rootElement = root.getChild("ProvidePlats");
        List<Element> providePlats = rootElement.getChildren();
        for (Element element : providePlats) {
            String id = element.getAttributeValue("id");
            String ip = element.getAttributeValue("ip");
            String layer = element.getAttributeValue("layer");
            PlatInstance plat = new PlatInstance(id);
            plat.init();
            this.plats.put(id, plat);
        }
    }

    private static class ProvidePlatManagerHolder {
        private static final PlatManager INSTANCE = new PlatManager();

        private ProvidePlatManagerHolder() {
        }
    }
}

