/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.data.BasicConfig;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class MachineParams {
    protected static final Logger logger = Logger.getLogger(MachineParams.class);
    private int clearMode;
    private int clearStopCircles;
    private int clearStopTime;
    private int maxLoopCircles;
    private int maxScanTimes;
    private int noreadWarn;
    private int pidaiCheckTime;
    private int pidaiInterval;
    private String runStatus;
    private int saveElecTime;
    private int serverNoDataTime;
    private int sorterSpeed;
    private int startWarnTime;
    private String sortMode;

    public static MachineParams getInstance() {
        return MachineParamsHolder.INSTANCE;
    }

    private MachineParams() {
    }

    public static Logger getLogger() {
        return logger;
    }

    public int getClearMode() {
        return this.clearMode;
    }

    public void setClearMode(int clearMode) {
        this.clearMode = clearMode;
    }

    public int getClearStopCircles() {
        return this.clearStopCircles;
    }

    public void setClearStopCircles(int clearStopCircles) {
        this.clearStopCircles = clearStopCircles;
    }

    public int getClearStopTime() {
        return this.clearStopTime;
    }

    public void setClearStopTime(int clearStopTime) {
        this.clearStopTime = clearStopTime;
    }

    public int getMaxLoopCircles() {
        return this.maxLoopCircles;
    }

    public void setMaxLoopCircles(int maxLoopCircles) {
        this.maxLoopCircles = maxLoopCircles;
    }

    public int getMaxScanTimes() {
        return this.maxScanTimes;
    }

    public void setMaxScanTimes(int maxScanTimes) {
        this.maxScanTimes = maxScanTimes;
    }

    public int getNoreadWarn() {
        return this.noreadWarn;
    }

    public void setNoreadWarn(int noreadWarn) {
        this.noreadWarn = noreadWarn;
    }

    public int getPidaiCheckTime() {
        return this.pidaiCheckTime;
    }

    public void setPidaiCheckTime(int pidaiCheckTime) {
        this.pidaiCheckTime = pidaiCheckTime;
    }

    public int getPidaiInterval() {
        return this.pidaiInterval;
    }

    public void setPidaiInterval(int pidaiInterval) {
        this.pidaiInterval = pidaiInterval;
    }

    public String getRunStatus() {
        return this.runStatus;
    }

    public void setRunStatus(String runStatus) {
        this.runStatus = runStatus;
    }

    public int getSaveElecTime() {
        return this.saveElecTime;
    }

    public void setSaveElecTime(int saveElecTime) {
        this.saveElecTime = saveElecTime;
    }

    public int getServerNoDataTime() {
        return this.serverNoDataTime;
    }

    public void setServerNoDataTime(int serverNoDataTime) {
        this.serverNoDataTime = serverNoDataTime;
    }

    public int getSorterSpeed() {
        return this.sorterSpeed;
    }

    public void setSorterSpeed(int sorterSpeed) {
        this.sorterSpeed = sorterSpeed;
    }

    public int getStartWarnTime() {
        return this.startWarnTime;
    }

    public void setStartWarnTime(int startWarnTime) {
        this.startWarnTime = startWarnTime;
    }

    public String getSortMode() {
        return this.sortMode;
    }

    public void setSortMode(String sortMode) {
        this.sortMode = sortMode;
    }

    public void loadBasicConfig() {
        try {
            HashMap<String, String> configMap = new HashMap<String, String>();
            ICommand command = CommandCreator.getInstance().createCommand("FetchBasicConfigCmd", configMap);
            SQLCommandExecutor.getInstance().executeCmd(command);
            if (configMap != null && configMap.size() > 0) {
                this.setBasicConfigs(configMap);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[SorterParameter.initSortParams] init sorter params error: " + ex);
        }
    }

    public void setBasicConfigs(HashMap<String, String> configMap) {
        String sortModeValue;
        String pidaiCheckTimeValue;
        String pidaiIntervalValue;
        String saveElecTimeValue;
        String noreadWarnValue;
        String clearStopCirclesValue;
        String clearStopTimeValue;
        String startWarnTimeValue;
        String sorterSpeedValue;
        String clearModeValue;
        String maxScanTimesValue;
        String maxLoopCirclesValue = configMap.get("maxTurnNumber");
        if (maxLoopCirclesValue != null) {
            try {
                this.maxLoopCircles = Integer.parseInt(maxLoopCirclesValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((maxScanTimesValue = configMap.get("maxScanNumber")) != null) {
            try {
                this.maxScanTimes = Integer.parseInt(maxScanTimesValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((clearModeValue = configMap.get("clearMode")) != null) {
            try {
                this.clearMode = Integer.parseInt(clearModeValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((sorterSpeedValue = configMap.get("sorterSpeed")) != null) {
            try {
                this.sorterSpeed = Integer.parseInt(sorterSpeedValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((startWarnTimeValue = configMap.get("startWarnTime")) != null) {
            try {
                this.startWarnTime = Integer.parseInt(startWarnTimeValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((clearStopTimeValue = configMap.get("clearStopTime")) != null) {
            try {
                this.clearStopTime = Integer.parseInt(clearStopTimeValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((clearStopCirclesValue = configMap.get("clearStopCircles")) != null) {
            try {
                this.clearStopCircles = Integer.parseInt(clearStopCirclesValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((noreadWarnValue = configMap.get("noreadWarn")) != null) {
            try {
                this.noreadWarn = Integer.parseInt(noreadWarnValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((saveElecTimeValue = configMap.get("saveElecTime")) != null) {
            try {
                this.saveElecTime = Integer.parseInt(saveElecTimeValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((pidaiIntervalValue = configMap.get("pidaiInterval")) != null) {
            try {
                this.setPidaiInterval(Integer.parseInt(pidaiIntervalValue));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((pidaiCheckTimeValue = configMap.get("pidaiCheckTime")) != null) {
            try {
                this.setPidaiCheckTime(Integer.parseInt(pidaiCheckTimeValue));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((sortModeValue = configMap.get("sortMode")) != null) {
            try {
                this.setSortMode(sortModeValue);
            }
            catch (Exception e) {
                LogUtil.LogError(logger, "[SorterParameter.initSortParams] init sorter params sortMode error!");
            }
        }
    }

    public void setSortingSortMode() {
        this.renewSortModeStatus("sorting");
    }

    public void setTransferringSortMode() {
        this.renewSortModeStatus("transferring");
    }

    private void renewSortModeStatus(String value) {
        BasicConfig basicConfig = new BasicConfig();
        basicConfig.setBasicKey("sortMode");
        basicConfig.setBasicValue(value);
        ICommand command = CommandCreator.getInstance().createCommand("RenewBasicConfigCmd", basicConfig);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }

    private static class MachineParamsHolder {
        private static MachineParams INSTANCE = new MachineParams();

        private MachineParamsHolder() {
        }
    }
}

