/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl.web;

import com.simba.common.command.ICommand;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.SorterParams;
import com.simba.server.components.data.PacketOnInfo;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class WebUploadWeightInfoCmd
implements ICommand {
    public static final String NAME = "WebUploadWeightInfoCmd";
    private static final Logger logger = Logger.getLogger(WebUploadWeightInfoCmd.class);
    private final PacketOnInfo packetOnInfo;

    public WebUploadWeightInfoCmd(PacketOnInfo packetOnInfo) {
        this.packetOnInfo = packetOnInfo;
    }

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        String urlPostFix = "/pipeline/v2/start_stop";
        String serverHost = SorterParams.getInstance().getServerHost();
        String serverPort = SorterParams.getInstance().getServerPort();
        if (!SorterParams.getInstance().isNeedDataUpload()) {
            serverHost = SorterParams.getInstance().getDebugServerHost();
            serverPort = SorterParams.getInstance().getDebugServerPort();
        }
        String url = "http://" + serverHost + ":" + serverPort + urlPostFix;
        HttpPost postRequest = new HttpPost(url);
        String content = SortProtocolCreator.getInstance().createUploadWeightResult(this.packetOnInfo);
        StringEntity contentEntity = new StringEntity(content, "UTF-8");
        contentEntity.setContentEncoding("UTF-8");
        contentEntity.setContentType("application/json");
        postRequest.setEntity(contentEntity);
        CloseableHttpResponse response = null;
        try {
            response = WebCommandExecutor.getInstance().doHttpServiceByPost(postRequest);
            HttpEntity entity = response.getEntity();
            byte[] contentBuffer = EntityUtils.toByteArray(entity);
            content = new String(contentBuffer, "UTF-8");
            JSONObject responseObj = new JSONObject(content);
            if (responseObj.has("status") || !responseObj.isNull("status")) {
                int status = responseObj.getInt("status");
                if (status == 1) {
                    this.printWebUploadWeightInfoSuccess();
                    ret = true;
                } else {
                    this.printWebUploadWeightInfoFailed();
                    ret = false;
                }
            } else {
                this.printWebUploadWeightInfoFailed();
                ret = false;
            }
        }
        catch (IOException ex) {
            LogUtil.LogError(logger, "[WebUploadWeightInfoCmd] Catch IO Exception when request sort info , Request Content:[" + content + "] Exception Message:" + ex.getMessage());
            ret = false;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException ex) {
                    LogUtil.LogError(logger, "[WebUploadWeightInfoCmd] Catch an exception when close a http response :" + ex.getMessage());
                }
            }
        }
        return ret;
    }

    private void printWebUploadWeightInfoFailed() {
        try {
            StringBuilder info = new StringBuilder("[Offer Weight Upload Failed!]");
            info.append(",[PlatId:");
            info.append(this.packetOnInfo.getPlatId());
            info.append("],[CarId:");
            info.append(this.packetOnInfo.getCarId());
            info.append("],[Status:");
            info.append(this.packetOnInfo.getWeight());
            info.append("]");
            LogUtil.LogDebug(logger, info.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void printWebUploadWeightInfoSuccess() {
        try {
            StringBuilder info = new StringBuilder("[Offer Weight Upload Success]");
            info.append(",[PlatId:");
            info.append(this.packetOnInfo.getPlatId());
            info.append("],[TrayCode:");
            info.append(this.packetOnInfo.getTrayCode());
            info.append("],[Status:");
            info.append(this.packetOnInfo.getWeight());
            info.append("]");
            LogUtil.LogDebug(logger, info.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

