/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl.web;

import com.simba.common.command.ICommand;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.SorterParams;
import com.simba.server.components.data.SortInfo;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class WebSortInfoCmd
implements ICommand {
    public static final String NAME = "WebSortInfoCmd";
    private static final Logger logger = Logger.getLogger(WebSortInfoCmd.class);
    private final SortInfo sortInfo;

    public WebSortInfoCmd(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        String urlPostFix = "/wcs/v2/sorting_info";
        String serverHost = SorterParams.getInstance().getServerHost();
        String serverPort = SorterParams.getInstance().getServerPort();
        if (!SorterParams.getInstance().isNeedDataUpload()) {
            serverHost = SorterParams.getInstance().getDebugServerHost();
            serverPort = SorterParams.getInstance().getDebugServerPort();
        }
        String url = "http://" + serverHost + ":" + serverPort + urlPostFix;
        HttpPost postRequest = new HttpPost(url);
        String content = SortProtocolCreator.getInstance().createSortInfoResult(this.sortInfo);
        StringEntity contentEntity = new StringEntity(content, "UTF-8");
        contentEntity.setContentEncoding("UTF-8");
        contentEntity.setContentType("application/json");
        postRequest.setEntity(contentEntity);
        CloseableHttpResponse response = null;
        try {
            response = WebCommandExecutor.getInstance().doHttpServiceByPost(postRequest);
            HttpEntity entity = response.getEntity();
            byte[] contentBuffer = EntityUtils.toByteArray(entity);
            content = new String(contentBuffer, "UTF-8");
            JSONObject responseObj = new JSONObject(content);
            if (!responseObj.has("status") || responseObj.isNull("status")) {
                this.sortInfo.setErrorCodeSVR(9);
            } else {
                this.handleWithReturnCode(responseObj);
            }
            ret = true;
            LogUtil.LogDebug(logger, "[WebSortInfoCmd] Response Content:[" + content + "] Response Content:[" + responseObj.toString() + "]");
        }
        catch (IOException ex) {
            LogUtil.LogError(logger, "[WebSortInfoCmd] Catch IO Exception when request sort info , Request Content:[" + content + "] Exception Message:" + ex.getMessage());
            this.sortInfo.setErrorCodeSVR(10);
            ret = false;
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[WebSortInfoCmd] Catch UnKnow Exception when request sort info , Request Content:[" + content + "] Exception Message:" + ex.getMessage());
            this.sortInfo.setErrorCodeSVR(9);
            ret = false;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException ex) {
                    LogUtil.LogError(logger, "Catch an exception when close a http response :" + ex.getMessage());
                }
            }
        }
        return ret;
    }

    private void handleWithReturnCode(JSONObject responseObj) {
        int errorCode = 0;
        int status = responseObj.getInt("status");
        if (status == 1) {
            if (responseObj.has("result") && !responseObj.isNull("result")) {
                JSONObject resultObj = responseObj.getJSONObject("result");
                errorCode = this.getChuteCodes(resultObj);
                String sortSource = "noSortSource";
                if (responseObj.has("sortSource") && !responseObj.isNull("sortSource")) {
                    sortSource = resultObj.getString("sortSource");
                }
                this.sortInfo.setSortSource(sortSource);
                String sortCode = "noSortCode";
                if (responseObj.has("sortCode") && !responseObj.isNull("sortCode")) {
                    sortCode = resultObj.getString("sortCode");
                }
                this.sortInfo.setSortSource(sortCode);
                this.sortInfo.setErrorCodeSVR(0);
            } else {
                errorCode = 10;
                this.sortInfo.setErrorCodeSVR(errorCode);
                this.sortInfo.getSlotsList().clear();
                this.sortInfo.getChuteCodeList().clear();
            }
        } else {
            errorCode = 10;
        }
        this.sortInfo.setErrorCodeSVR(errorCode);
    }

    private int getChuteCodes(JSONObject responseObj) {
        int errorCode = 0;
        JSONArray chuteCodeArray = responseObj.getJSONArray("sortPortCode");
        int chuteCodeLength = chuteCodeArray.length();
        if (chuteCodeLength > 0) {
            this.sortInfo.getSlotsList().clear();
            this.sortInfo.getChuteCodeList().clear();
        } else {
            this.sortInfo.setErrorCodeSVR(1);
        }
        for (int i = 0; i < chuteCodeLength; ++i) {
            String slotId = chuteCodeArray.getString(i);
            slotId = slotId.substring(slotId.length() - 3);
            this.sortInfo.getSlotsList().add(Integer.parseInt(slotId));
            this.sortInfo.getChuteCodeList().add(slotId);
        }
        return errorCode;
    }
}

