/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl.web;

import com.simba.common.command.ICommand;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.SorterParams;
import com.simba.server.components.data.SortResult;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class WebPacketOffCmd
implements ICommand {
    public static final String NAME = "WebPacketOffCmd";
    private static final Logger logger = Logger.getLogger(WebPacketOffCmd.class);
    private final SortResult sortResult;

    public WebPacketOffCmd(SortResult sortResult) {
        this.sortResult = sortResult;
    }

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        String urlPostFix = "/wcs/v2/sorting_result";
        String serverHost = SorterParams.getInstance().getServerHost();
        String serverPort = SorterParams.getInstance().getServerPort();
        if (!SorterParams.getInstance().isNeedDataUpload()) {
            serverHost = SorterParams.getInstance().getDebugServerHost();
            serverPort = SorterParams.getInstance().getDebugServerPort();
        }
        String url = "http://" + serverHost + ":" + serverPort + urlPostFix;
        HttpPost postRequest = new HttpPost(url);
        String content = SortProtocolCreator.getInstance().createSortResult(this.sortResult);
        StringEntity contentEntity = new StringEntity(content, "UTF-8");
        contentEntity.setContentEncoding("UTF-8");
        contentEntity.setContentType("application/json");
        postRequest.setEntity(contentEntity);
        CloseableHttpResponse response = null;
        try {
            response = WebCommandExecutor.getInstance().doHttpServiceByPost(postRequest);
            HttpEntity entity = response.getEntity();
            byte[] contentBuffer = EntityUtils.toByteArray(entity);
            content = new String(contentBuffer, "UTF-8");
            JSONObject responseObj = new JSONObject(content);
            if (responseObj.has("status") || !responseObj.isNull("status")) {
                int status = responseObj.getInt("status");
                if (status == 1) {
                    this.printWebPacketOffSuccess();
                    ret = true;
                } else {
                    this.printWebPacketOffFailed();
                    ret = false;
                }
            } else {
                this.printWebPacketOffFailed();
                ret = false;
            }
        }
        catch (IOException ex) {
            LogUtil.LogError(logger, "[WebPacketOffCmd] Catch IO Exception when request sort info , Request Content:[" + content + "] Exception Message:" + ex.getMessage());
            ret = false;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException ex) {
                    LogUtil.LogError(logger, "[WebPacketOffCmd] Catch an exception when close a http response :" + ex.getMessage());
                }
            }
        }
        return ret;
    }

    private void printWebPacketOffFailed() {
        try {
            StringBuilder infoBuidler = new StringBuilder("[Offer Packet Off Failed],[barcode:");
            String barcode = "";
            if (this.sortResult.getSortInfos().size() > 0) {
                barcode = this.sortResult.getSortInfos().get(0).getBarcode();
            }
            infoBuidler.append(barcode);
            infoBuidler.append("],[boxCode:");
            infoBuidler.append(this.sortResult.getBoxCode());
            infoBuidler.append("],[SlotId:");
            infoBuidler.append(this.sortResult.getSlotId());
            infoBuidler.append("]");
            LogUtil.LogDebug(logger, infoBuidler.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void printWebPacketOffSuccess() {
        try {
            StringBuilder info = new StringBuilder("[Offer Packet Off Success],[barcode:");
            String barcode = "";
            if (this.sortResult.getSortInfos().size() > 0) {
                barcode = this.sortResult.getSortInfos().get(0).getBarcode();
            }
            info.append(barcode);
            info.append("],[carId:");
            info.append(this.sortResult.getSortInfos().get(0).getCarId());
            info.append("],[SortingId:");
            info.append(this.sortResult.getSortInfos().get(0).getSortingId());
            info.append("],[PlatId:");
            info.append(this.sortResult.getSortInfos().get(0).getPlatId());
            info.append("],[PlcId:");
            info.append(this.sortResult.getSortInfos().get(0).getPlcId());
            info.append("]");
            LogUtil.LogDebug(logger, info.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

