/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl.database;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.data.BoxInfo;
import com.simba.server.components.data.SlotInfo;

public class RecordBoxPackCmd
implements ICommand {
    public static final String NAME = "RecordBoxPackCmd";
    private final BoxInfo boxInfo;
    private final SlotInfo slotInfo;
    private final String sql = "insert into tt_slot_pack_info( slotId, chuteCode, boxCode, boxType, createTime, mailCount) values(?,?,?,?,?,?);";

    public RecordBoxPackCmd(SlotInfo slotInfo) {
        this.slotInfo = slotInfo;
        this.boxInfo = this.slotInfo.getBoxInfo();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            String slotId = this.boxInfo.getSlotId();
            if (slotId == null || slotId.equals("")) {
                slotId = "none";
            }
            dbOperator.setString(1, slotId);
            String chuteCode = this.boxInfo.getChuteCode();
            if (chuteCode == null || chuteCode.equals("")) {
                chuteCode = "none";
            }
            dbOperator.setString(2, chuteCode);
            String boxCode = this.boxInfo.getBoxCode();
            if (boxCode == null || boxCode.equals("")) {
                boxCode = "none";
            }
            dbOperator.setString(3, boxCode);
            String boxType = this.boxInfo.getBoxType();
            if (boxType == null || boxType.equals("")) {
                boxType = "none";
            }
            dbOperator.setString(4, boxType);
            String createTime = this.boxInfo.getCreateTime();
            if (createTime == null || createTime.equals("")) {
                createTime = "none";
            }
            dbOperator.setString(5, createTime);
            dbOperator.setInt(6, this.boxInfo.getMailCount());
            int res = dbOperator.executeUpdate();
            ret = res > 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

