/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl.database;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.data.SlotInfo;
import java.sql.ResultSet;

public class FetchPacketCountCmd
implements ICommand {
    public static final String NAME = "FetchPacketCountCmd";
    private final SlotInfo slotInfo;
    private final String sql = "select count(*) as cn from tt_packet_off_info where boxCode=?;";

    public FetchPacketCountCmd(SlotInfo slotInfo) {
        this.slotInfo = slotInfo;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            dbOperator.setString(1, this.slotInfo.getBoxInfo().getBoxCode());
            ResultSet rs = dbOperator.executeQuery();
            if (rs.next()) {
                int count = rs.getInt("cn");
                this.slotInfo.getBoxInfo().setMailCount(count);
                ret = true;
            }
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

