/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl.database;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.data.DeleteData;

public class DelScannedInfoCmd
implements ICommand {
    public static final String NAME = "DelScannedInfoCmd";
    private final DeleteData delScannedInfo;
    private final String sql = "delete from tt_scanned_info where scannedTime<? limit 10000;";

    public DelScannedInfoCmd(DeleteData delInfo) {
        this.delScannedInfo = delInfo;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            dbOperator.setTimestamp(1, this.delScannedInfo.getDeleteBeforeTime());
            int delCount = dbOperator.executeUpdate();
            if (delCount > 0) {
                this.delScannedInfo.setDelCount(delCount);
            }
            ret = true;
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

