/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands;

import com.simba.common.command.ICommand;
import com.simba.server.commands.impl.database.DelPacketOffCmd;
import com.simba.server.commands.impl.database.DelPacketOnCmd;
import com.simba.server.commands.impl.database.DelScannedInfoCmd;
import com.simba.server.commands.impl.database.DelSlotPackCmd;
import com.simba.server.commands.impl.database.FetchBasicConfigCmd;
import com.simba.server.commands.impl.database.FetchPacketCountCmd;
import com.simba.server.commands.impl.database.FetchPacketOffCmd;
import com.simba.server.commands.impl.database.FetchSlotInfoCmd;
import com.simba.server.commands.impl.database.FetchTrashSlotsCmd;
import com.simba.server.commands.impl.database.RecordBoxPackCmd;
import com.simba.server.commands.impl.database.RecordMachineOpsCmd;
import com.simba.server.commands.impl.database.RecordPacketOffCmd;
import com.simba.server.commands.impl.database.RecordPacketOnCmd;
import com.simba.server.commands.impl.database.RecordPlatScannedCmd;
import com.simba.server.commands.impl.database.RenewBasicConfigCmd;
import com.simba.server.commands.impl.database.RenewSortResultCmd;
import com.simba.server.commands.impl.database.TruncateTableCmd;
import com.simba.server.commands.impl.web.WebMachineStatusUploadCmd;
import com.simba.server.commands.impl.web.WebPacketOffCmd;
import com.simba.server.commands.impl.web.WebSortInfoCmd;
import com.simba.server.commands.impl.web.WebUploadWeightInfoCmd;
import com.simba.server.components.data.BasicConfig;
import com.simba.server.components.data.DeleteData;
import com.simba.server.components.data.MachineOps;
import com.simba.server.components.data.PacketOnInfo;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.components.data.SortInfo;
import com.simba.server.components.data.SortResult;
import com.simba.server.components.data.SorterStatus;
import com.simba.server.components.data.TrashSlotInfo;
import java.util.HashMap;
import java.util.List;

public class CommandCreator {
    public static CommandCreator getInstance() {
        return CommandCreatorHolder.INSTANCE;
    }

    private CommandCreator() {
    }

    public ICommand createCommand(String cmdName, Object paramsObj) {
        ICommand command = null;
        switch (cmdName) {
            case "RecordPacketOffCmd": {
                command = new RecordPacketOffCmd((SortInfo)paramsObj);
                break;
            }
            case "RecordPacketOnCmd": {
                command = new RecordPacketOnCmd((PacketOnInfo)paramsObj);
                break;
            }
            case "RecordPlatScannedCmd": {
                command = new RecordPlatScannedCmd((SortInfo)paramsObj);
                break;
            }
            case "RecordMachineOpsCmd": {
                command = new RecordMachineOpsCmd((MachineOps)paramsObj);
                break;
            }
            case "FetchSlotInfoCmd": {
                command = new FetchSlotInfoCmd((List)paramsObj);
                break;
            }
            case "FetchTrashSlotsCmd": {
                command = new FetchTrashSlotsCmd((TrashSlotInfo)paramsObj);
                break;
            }
            case "RecordBoxPackCmd": {
                command = new RecordBoxPackCmd((SlotInfo)paramsObj);
                break;
            }
            case "FetchPacketCountCmd": {
                command = new FetchPacketCountCmd((SlotInfo)paramsObj);
                break;
            }
            case "FetchPacketOffCmd": {
                command = new FetchPacketOffCmd((SortInfo)paramsObj);
                break;
            }
            case "FetchBasicConfigCmd": {
                command = new FetchBasicConfigCmd((HashMap)paramsObj);
                break;
            }
            case "RenewSortResultCmd": {
                command = new RenewSortResultCmd((SortInfo)paramsObj);
                break;
            }
            case "RenewBasicConfigCmd": {
                command = new RenewBasicConfigCmd((BasicConfig)paramsObj);
                break;
            }
            case "DelPacketOffCmd": {
                command = new DelPacketOffCmd((DeleteData)paramsObj);
                break;
            }
            case "DelSlotPackCmd": {
                command = new DelSlotPackCmd((DeleteData)paramsObj);
                break;
            }
            case "DelPacketOnCmd": {
                command = new DelPacketOnCmd((DeleteData)paramsObj);
                break;
            }
            case "DelScannedInfoCmd": {
                command = new DelScannedInfoCmd((DeleteData)paramsObj);
                break;
            }
            case "TruncateTableCmd": {
                command = new TruncateTableCmd((String)paramsObj);
                break;
            }
            case "WebUploadWeightInfoCmd": {
                command = new WebUploadWeightInfoCmd((PacketOnInfo)paramsObj);
                break;
            }
            case "WebSortInfoCmd": {
                command = new WebSortInfoCmd((SortInfo)paramsObj);
                break;
            }
            case "WebPacketOffCmd": {
                command = new WebPacketOffCmd((SortResult)paramsObj);
                break;
            }
            case "WebMachineStatusUploadCmd": {
                command = new WebMachineStatusUploadCmd((SorterStatus)paramsObj);
                break;
            }
        }
        return command;
    }

    private static class CommandCreatorHolder {
        private static CommandCreator INSTANCE = new CommandCreator();

        private CommandCreatorHolder() {
        }
    }
}

