/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.search.AddressTerm;

public final class RecipientTerm
extends AddressTerm {
    protected Message.RecipientType type;

    public RecipientTerm(Message.RecipientType type, Address address) {
        super(address);
        this.type = type;
    }

    public boolean equals(Object other) {
        return super.equals(other) && ((RecipientTerm)other).type.equals(this.type);
    }

    public Message.RecipientType getRecipientType() {
        return this.type;
    }

    public int hashCode() {
        return super.hashCode() + this.type.hashCode();
    }

    public boolean match(Message message) {
        try {
            Address[] from = message.getRecipients(this.type);
            boolean result = false;
            for (int i = 0; !result && i < from.length; ++i) {
                result = this.match(from[i]);
            }
            return result;
        }
        catch (MessagingException e) {
            return false;
        }
    }
}

