/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.netclient;

import com.simba.common.frameclient.BaseClient;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LogUtil;
import com.simba.common.log.LoggerExecutor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;
import org.json.JSONTokener;

public class ClientLuolai
extends BaseClient {
    private static final Logger logger = Logger.getLogger(ClientLuolai.class);
    public static final String JSON_SERVICE_NAME = "ServiceName";

    @Override
    public void messageReceived(Channel channel, Object message) {
        try {
            byte[] receiveBuffer = (byte[])message;
            String jsonString = new String(receiveBuffer, "UTF-8");
            LogUtil.LogInfo(logger, "[ClientSto.messageReceived] recv msg : " + jsonString);
            if (jsonString.equalsIgnoreCase("ack")) {
                return;
            }
            JSONTokener jsonTokener = new JSONTokener(jsonString);
            JSONObject requestJSONObject = (JSONObject)jsonTokener.nextValue();
            String serviceName = requestJSONObject.getString(JSON_SERVICE_NAME);
            int HeaderID = requestJSONObject.getInt("HeaderID");
            String Uuid = requestJSONObject.getString("Uuid");
            if (serviceName == null) {
                return;
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[ClientSto.messageReceived] Catch an exception : " + ex.getMessage(), 2));
        }
    }

    @Override
    public void onChannelConnected(Channel channel) {
    }

    @Override
    public void send(byte[] content) {
        try {
            if (content == null || content.length == 0) {
                return;
            }
            int allMsgLength = content.length;
            byte[] sendBuffer = new byte[allMsgLength];
            System.arraycopy(content, 0, sendBuffer, 0, content.length);
            this.connection.send(sendBuffer, false);
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[ClientLuolai.send]  : " + new String(sendBuffer, "UTF-8"), 3));
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[ClientLuolai.send] Catch an exception : " + ex.getMessage(), 2));
        }
    }

    public static byte[] my_int_to_bb_le(int myInteger) {
        return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(myInteger).array();
    }

    public static int my_bb_to_int_le(byte[] byteBarray) {
        return ByteBuffer.wrap(byteBarray).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public static byte[] my_int_to_bb_be(int myInteger) {
        return ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(myInteger).array();
    }
}

