/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.jsonservice.serivces;

import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.jsonservice.JsonService;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.data.SlotInfo;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONException;
import org.json.JSONObject;

public class SlotBindJsonService
implements JsonService {
    public static final String NAME = "SlotPacketBind";
    private static final Logger logger = Logger.getLogger(SlotBindJsonService.class);

    @Override
    public void handleRequest(Channel channel, Object content) {
        try {
            JSONObject request = (JSONObject)content;
            String name = request.getString("ServiceName");
            if (name == null || !name.equals(NAME)) {
                return;
            }
            String slotId = request.getString("slotCode");
            slotId = Integer.toString(Integer.parseInt(slotId));
            SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(slotId);
            if (slotInfo == null) {
                return;
            }
            String packetCode = request.getString("packetCode");
            String contentString = content.toString();
            if (packetCode.length() >= 18) {
                packetCode = packetCode.substring(0, 13);
            }
            boolean isPackageValid = false;
            boolean isBindedOtherSlot = false;
            Pattern pattern = Pattern.compile("[0-9]*");
            if (packetCode.startsWith("900") && pattern.matcher(packetCode).matches()) {
                isPackageValid = true;
            }
            if (packetCode.length() < 12 || slotId.length() > 4 || !packetCode.startsWith("900") || isBindedOtherSlot || !isPackageValid) {
                request.putOpt("slotCode", "0");
                request.putOpt("packetCode", "0");
                request.putOpt("status", "0");
                JsonChannelManager.getInstance().commitResponse(channel, request.toString().getBytes(), false);
                return;
            }
            request.putOpt("status", "1");
            JsonChannelManager.getInstance().commitResponse(channel, contentString.getBytes(), false);
            slotInfo.setRequestObj(request);
            SortControllerManager.getInstance().onSlotBindMessage(slotInfo);
        }
        catch (JSONException ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Slot bind Json Service Error : exception info : ", 2));
        }
    }
}

