/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.jsonservice.serivces;

import com.simba.common.jsonservice.JsonService;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.PlatInstance;
import com.simba.server.components.PlatInstanceManager;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONException;
import org.json.JSONObject;

public class ScannedJsonService
implements JsonService {
    public static final String NAME = "PlatScanned";
    private static final Logger logger = Logger.getLogger(ScannedJsonService.class);

    @Override
    public void handleRequest(Channel channel, Object content) {
        try {
            JSONObject request = (JSONObject)content;
            String name = request.getString("ServiceName");
            if (name == null || !name.equals(NAME)) {
                return;
            }
            String platId = request.getString("platId");
            PlatInstance plat = PlatInstanceManager.getInstance().getPlatById(platId);
            if (plat == null) {
                this.sendErrorPlatIdResponse(channel, platId);
            }
            plat.handleScannedCommand(channel, request);
        }
        catch (JSONException ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Barcode Scanned Json Service Error : exception info : ", 2));
        }
    }

    private void sendErrorPlatIdResponse(Channel channel, String platId) {
    }
}

