/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.jsonservice.serivces;

import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.jsonservice.JsonService;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.OrderManager;
import com.simba.server.components.SlotManager;
import com.simba.server.components.data.SlotInfo;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class ResetSlotColorJsonService
implements JsonService {
    public static final String NAME = "ResetSlotColor";
    private static final Logger logger = Logger.getLogger(ResetSlotColorJsonService.class);

    @Override
    public void handleRequest(Channel channel, Object content) {
        try {
            JSONObject LoginObj = (JSONObject)content;
            String slot = LoginObj.getString("slot");
            this.changeSlotColor(slot);
            JSONObject contentObj = new JSONObject();
            contentObj.put("ServiceName", "AckResetSlot");
            contentObj.put("resetStatus", 1);
            String requestContent = contentObj.toString();
            JsonChannelManager.getInstance().commitResponse(channel, requestContent.getBytes(), false);
        }
        catch (Exception e) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[LoginJsonService.handleRequest] error : " + e.getMessage(), 2));
        }
    }

    private void changeSlotColor(String slotId) {
        try {
            SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(slotId);
            if (slotInfo == null) {
                return;
            }
            slotInfo.setLpnStatus(1);
            OrderManager.getInstance().senSlotLightoPlc(slotInfo);
        }
        catch (Exception e) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[changeSlotColor] error : " + e.getMessage(), 2));
        }
    }
}

