/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.jsonservice.serivces;

import com.simba.common.jsonservice.JsonService;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.ServerManager;
import com.simba.server.components.data.OrderInfo;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OrderInfoJsonService
implements JsonService {
    public static final String NAME = "OrderInfo";
    private static final Logger logger = Logger.getLogger(OrderInfoJsonService.class);

    @Override
    public void handleRequest(Channel channel, Object content) {
        try {
            JSONObject request = (JSONObject)content;
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "get order info : " + request.toString(), 1));
            String name = request.getString("ServiceName");
            if (name == null || !name.equals(NAME)) {
                return;
            }
            String waveID = request.getString("WaveID");
            String TaskID = request.getString("TaskID");
            LinkedList<OrderInfo> orderLists = new LinkedList<OrderInfo>();
            JSONArray lpns = request.getJSONArray("Lpns");
            if (lpns.length() > 0) {
                for (int i = 0; i < lpns.length(); ++i) {
                    JSONObject jObject = lpns.getJSONObject(i);
                    OrderInfo orderInfo = new OrderInfo();
                    orderInfo.setLpn(jObject.getString("Lpn"));
                    orderInfo.setSkuID(jObject.getString("Sku"));
                    orderInfo.setSkuBarcode(jObject.getString("SkuBrcd"));
                    orderInfo.setSkuQty(jObject.getInt("SkuQty"));
                    orderInfo.setLpnQty(jObject.getInt("LpnQty"));
                    double lpnWeight = jObject.getDouble("LpnWeight");
                    int isCanelOrder = 0;
                    if (jObject.has("IsOrderCancel")) {
                        isCanelOrder = jObject.getInt("IsOrderCancel");
                    }
                    orderInfo.setIsCancelOrder(isCanelOrder);
                    orderInfo.setLpnWeight(lpnWeight);
                    orderInfo.setWayDirection(jObject.getInt("WayDirection"));
                    orderInfo.setWaveID(waveID);
                    orderInfo.setTaskID(TaskID);
                    orderLists.add(orderInfo);
                }
            }
            ServerManager.getInstance().getOrderRestoreTask().offerOrderListToQueue(orderLists);
        }
        catch (JSONException ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "OrderInfoJsonService  Error : exception info : ", 2));
        }
    }
}

