/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.jsonservice.serivces;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.jsonservice.JsonService;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.SorterCommonParams;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.LoginStatus;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.controllers.luolai.LuolaiCommonParams;
import com.simba.server.netclient.DefaultClientManager;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class LoginJsonService
implements JsonService {
    public static final String NAME = "Login";
    private static final Logger logger = Logger.getLogger(LoginJsonService.class);

    @Override
    public void handleRequest(Channel channel, Object content) {
        try {
            JSONObject LoginObj = (JSONObject)content;
            String UserName = LoginObj.getString("UserName");
            String Password = LoginObj.getString("PassWord");
            LoginStatus loginStatus = new LoginStatus();
            loginStatus.setUserName(UserName);
            loginStatus.setPassword(Password);
            ICommand command = CommandCreator.getInstance().createCommand("LoginStatus", loginStatus);
            JSONObject contentObj = new JSONObject();
            contentObj.put("ServiceName", "AckLogin");
            boolean res = SQLCommandExecutor.getInstance().executeCmd(command);
            if (res) {
                contentObj.put("Result", "success");
            } else {
                contentObj.put("Result", "fail");
            }
            contentObj.put("isUseVC", String.valueOf(LuolaiCommonParams.getInstance().getIsUseVC()));
            contentObj.put("ftpUrl", LuolaiCommonParams.getInstance().getFtpUrl());
            contentObj.put("ftpUser", LuolaiCommonParams.getInstance().getFtpUser());
            contentObj.put("ftpPwd", LuolaiCommonParams.getInstance().getFtpPwd());
            contentObj.put("stoPattern", LuolaiCommonParams.getInstance().getStoPattern());
            contentObj.put("currentModel", SortControllerManager.getInstance().getCurrentSortInfoMode());
            contentObj.put("standWayBill", LuolaiCommonParams.getInstance().getStandPagkageWayBill());
            contentObj.put("standWeight", LuolaiCommonParams.getInstance().getStandWight());
            contentObj.put("standDiff", LuolaiCommonParams.getInstance().getMaxDiffWeight());
            contentObj.put("isDepWeightCare", LuolaiCommonParams.getInstance().isDepWeightCare());
            contentObj.put("depWeightLimit", LuolaiCommonParams.getInstance().getDepWeightLimit());
            contentObj.put("isArrivalWeightCare", LuolaiCommonParams.getInstance().isArrivalWeightCare());
            contentObj.put("arrivalWeightLimit", LuolaiCommonParams.getInstance().getArrivalWeightLimit());
            String requestContent = contentObj.toString();
            JsonChannelManager.getInstance().commitResponse(channel, requestContent.getBytes(), false);
        }
        catch (Exception e) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[LoginJsonService.handleRequest] error : " + e.getMessage(), 2));
        }
    }

    private void handleLoginMsgToMonitor(int platID, String loginName) {
        try {
            String strMsgContent = SorterProtocolCreator.getInstance().createLoginMsg(platID, loginName);
            byte[] content = strMsgContent.getBytes();
            DefaultClientManager.getInstance().sendUploadMsgToDefaultClient(content);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[LoginJsonService.handleLoginMsgToMonitor] error : " + ex.getMessage(), 2));
        }
    }

    private void autoSlotPackage() {
        try {
            String lastMode = SortControllerManager.getInstance().getCurrentSortInfoMode();
            if (lastMode.equals("Yunda")) {
                int slotNumber = SorterCommonParams.getInstance().getSlotNumber();
                for (int i = 1; i < slotNumber; ++i) {
                    SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(String.valueOf(i));
                    SortControllerManager.getInstance().onSlotPackMessage(slotInfo);
                }
            }
        }
        catch (Exception e) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[LoginJsonService.autoSlotPackage] error : " + e.getMessage(), 2));
        }
    }
}

