/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.jsonservice.serivces;

import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.jsonservice.JsonService;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.CommonDefines;
import com.simba.server.components.SorterProtocolCreator;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONException;
import org.json.JSONObject;

public class CheckTimeJsonService
implements JsonService {
    public static final String NAME = "CheckTime";
    private static final int CHECK_TIME_BUFFER_SIZE = 14;
    private static final Logger logger = Logger.getLogger(CheckTimeJsonService.class);

    @Override
    public void handleRequest(Channel channel, Object content) {
        try {
            JSONObject request = (JSONObject)content;
            String name = request.getString("ServiceName");
            if (name == null || !name.equals(NAME)) {
                return;
            }
            this.sendTimeToPlc();
        }
        catch (JSONException ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Check Time Json Service Error : exception info : ", 2));
        }
    }

    private void sendTimeToPlc() {
        try {
            Channel[] channels;
            byte[] replyBuffer = new byte[14];
            int position = 0;
            byte[] header = CommonDefines.REPLY_HEADER;
            System.arraycopy(header, 0, replyBuffer, position, header.length);
            byte[] command = new byte[]{17};
            System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
            byte[] timeBuffer = SorterProtocolCreator.getInstance().createSystemTimeToBuffer();
            System.arraycopy(timeBuffer, 0, replyBuffer, position += command.length, timeBuffer.length);
            byte[] serialByte = new byte[]{1};
            System.arraycopy(serialByte, 0, replyBuffer, position += timeBuffer.length, serialByte.length);
            byte[] replayEnder = CommonDefines.REPLY_ENDER;
            System.arraycopy(replayEnder, 0, replyBuffer, position += serialByte.length, replayEnder.length);
            position += replayEnder.length;
            for (Channel channel : channels = FrameChannelManager.getInstance().getChannelList()) {
                FrameChannelManager.getInstance().commitResponse(channel, replyBuffer, false);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "EchoTime Decode Catch Exception : " + ex.getMessage(), 2));
        }
    }
}

