/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.jsonservice;

import com.simba.common.RequestHandler;
import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.jsonservice.DefaultJsonServiceContainer;
import com.simba.common.jsonservice.JsonService;
import com.simba.common.jsonservice.JsonServiceContainer;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.common.thread.CommonExecutorFactory;
import com.simba.common.thread.CounterThreadFactory;
import com.simba.server.components.SorterCommonParams;
import com.simba.server.jsonservice.serivces.BusyStatusCheckJsonService;
import com.simba.server.jsonservice.serivces.CheckTimeJsonService;
import com.simba.server.jsonservice.serivces.DelOrderJsonService;
import com.simba.server.jsonservice.serivces.EchoJsonService;
import com.simba.server.jsonservice.serivces.ErrorJsonService;
import com.simba.server.jsonservice.serivces.GetVideoSortCodeService;
import com.simba.server.jsonservice.serivces.LoginJsonService;
import com.simba.server.jsonservice.serivces.OrderInfoJsonService;
import com.simba.server.jsonservice.serivces.RegistVideoJsonService;
import com.simba.server.jsonservice.serivces.RenewTrashSlotJsonService;
import com.simba.server.jsonservice.serivces.ResetPlatJsonService;
import com.simba.server.jsonservice.serivces.ResetSlotColorJsonService;
import com.simba.server.jsonservice.serivces.ScannedJsonService;
import com.simba.server.jsonservice.serivces.SlotBindJsonService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonServiceManager
implements RequestHandler {
    public static final String JSON_SERVICE_NAME = "ServiceName";
    protected static final Logger logger = Logger.getLogger(JsonServiceManager.class);
    private static int ASYNC_HTTP_EXECUTOR_POOL_SIZE = 6;
    private static final String ASYNC_OPERATION_EXECUTOR_NAME = "Json-Service-Task";
    private Executor asyncJsonServiceExecutor;
    private BlockingQueue<Runnable> asyncJsonServiceOperationQueue;
    private final JsonServiceContainer container = new DefaultJsonServiceContainer();

    public static JsonServiceManager getInstance() {
        return JsonServiceManagerHolder.INSTANCE;
    }

    private JsonServiceManager() {
    }

    @Override
    public void handleRequest(final Channel channel, Object requestObj) {
        final byte[] request = (byte[])requestObj;
        Runnable serviceTask = new Runnable(){

            @Override
            public void run() {
                block6: {
                    JsonService accessor = null;
                    try {
                        JSONObject requestJSONObject = JsonServiceManager.this.parseServiceJsonData(request);
                        if (requestJSONObject == null) {
                            return;
                        }
                        String serviceName = requestJSONObject.getString(JsonServiceManager.JSON_SERVICE_NAME);
                        if (serviceName == null) {
                            return;
                        }
                        accessor = JsonServiceManager.this.container.getJsonService(serviceName);
                        if (accessor == null) {
                            accessor = JsonServiceManager.this.container.getJsonService("Error");
                        }
                        if (accessor != null) {
                            accessor.handleRequest(channel, requestJSONObject);
                        }
                    }
                    catch (Exception ex) {
                        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "When Json server handlerRequest exception  [" + channel.getRemoteAddress() + "] -- " + ex.getMessage(), 2));
                        if (!(ex instanceof InterruptedException)) break block6;
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
        if (SorterCommonParams.getInstance().isNewThreadEachRequest()) {
            this.executeInNewThread(serviceTask);
        } else {
            this.executeInThreadPool(serviceTask);
        }
    }

    @Override
    public void onChannelConnected(Channel channel) {
    }

    @Override
    public void onChannelDisconnected(Channel channel) {
    }

    public void init() {
        this.initJsonServiceContainer();
        this.initAsyncJsonTaskExcutor();
    }

    public void postInitProcess() {
        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "JsonServiceManager initialize successfully", 3));
    }

    public void sendEchoDataToRemoteLogger() {
        Channel[] clientChannels;
        for (Channel channel : clientChannels = JsonChannelManager.getInstance().getChannelList()) {
            String sortInfoContent = "{\"ServiceName\":\"Echo\",\"Channel-Id\":\"" + channel.getId() + "\"}";
            JsonChannelManager.getInstance().commitResponse(channel, sortInfoContent.getBytes(), false);
        }
    }

    private void executeInNewThread(Runnable executeRunnable) {
        new Thread(executeRunnable).start();
    }

    private void executeInThreadPool(Runnable executeRunnable) {
        this.runAsyncJsonTask(executeRunnable);
    }

    private void initAsyncJsonTaskExcutor() {
        this.asyncJsonServiceOperationQueue = new LinkedBlockingQueue<Runnable>();
        this.asyncJsonServiceExecutor = CommonExecutorFactory.newFixedThreadPool(ASYNC_HTTP_EXECUTOR_POOL_SIZE, new CounterThreadFactory(ASYNC_OPERATION_EXECUTOR_NAME), this.asyncJsonServiceOperationQueue);
    }

    private void initJsonServiceContainer() {
        this.container.addJsonService("Echo", new EchoJsonService());
        this.container.addJsonService("Error", new ErrorJsonService());
        this.container.addJsonService("ResetPlat", new ResetPlatJsonService());
        this.container.addJsonService("PlatScanned", new ScannedJsonService());
        this.container.addJsonService("CheckTime", new CheckTimeJsonService());
        this.container.addJsonService("RenewTrashSlot", new RenewTrashSlotJsonService());
        this.container.addJsonService("SlotPacketBind", new SlotBindJsonService());
        this.container.addJsonService("Login", new LoginJsonService());
        this.container.addJsonService("GetVideoSortCode", new GetVideoSortCodeService());
        this.container.addJsonService("RegistVideo", new RegistVideoJsonService());
        this.container.addJsonService("BusyStatus", new BusyStatusCheckJsonService());
        this.container.addJsonService("OrderInfo", new OrderInfoJsonService());
        this.container.addJsonService("DelOrder", new DelOrderJsonService());
        this.container.addJsonService("ResetSlotColor", new ResetSlotColorJsonService());
    }

    private JSONObject parseServiceJsonData(byte[] request) {
        JSONObject requestJSONObject = null;
        try {
            String jsonString = new String(request, "UTF-8");
            JSONTokener jsonTokener = new JSONTokener(jsonString);
            requestJSONObject = (JSONObject)jsonTokener.nextValue();
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Parse Json service name exception -- " + ex.getMessage(), 2));
            requestJSONObject = null;
        }
        return requestJSONObject;
    }

    private void runAsyncJsonTask(Runnable task) {
        try {
            if (task != null) {
                this.asyncJsonServiceExecutor.execute(task);
            }
        }
        catch (Exception e) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "run async task to access json service request failed : " + e.getMessage(), 2));
        }
    }

    private static class JsonServiceManagerHolder {
        private static final JsonServiceManager INSTANCE = new JsonServiceManager();

        private JsonServiceManagerHolder() {
        }
    }
}

