/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.httpservice.Luolai;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.httpserver.HttpChannelManager;
import com.simba.common.httpserver.httpservice.HttpService;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.json.JSONObject;

public class StoVersionService
implements HttpService {
    public static final String NAME = "/v2/version_info";
    protected static final Logger logger = Logger.getLogger(StoVersionService.class);

    @Override
    public void handleRequest(Channel channel, Object content, HttpRequest request) {
        try {
            String message = (String)content;
            JSONObject requestObj = new JSONObject(message);
            String token = requestObj.getString("token");
            String timeStamp = requestObj.getString("timestamp");
            ConcurrentHashMap versionMap = new ConcurrentHashMap();
            ICommand command = CommandCreator.getInstance().createCommand("FetchVersionInfo", versionMap);
            boolean res = SQLCommandExecutor.getInstance().executeCmd(command);
            if (!res) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[StoVersionService.getversionInfo] error : ", 2));
            }
            JSONObject responseObj = new JSONObject();
            responseObj.put("ServiceName", "GetVersionInfo");
            responseObj.put("updateList", versionMap);
            String responseStr = responseObj.toString();
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            response.setStatus(HttpResponseStatus.OK);
            ByteBuffer rawContent = ByteBuffer.wrap(responseStr.getBytes());
            rawContent.rewind();
            ChannelBuffer channelBuffer = ChannelBuffers.wrappedBuffer(rawContent);
            response.setHeader("Content-Length", rawContent.limit());
            response.setContent(channelBuffer);
            HttpChannelManager.getInstance().commitResponse(channel, response, false);
        }
        catch (Exception e) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "get version Error : exception info : ", 2));
        }
    }
}

