/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.httpservice;

import com.simba.common.httpserver.HttpChannelManager;
import com.simba.common.httpserver.httpservice.HttpService;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.CookieDecoder;
import org.jboss.netty.handler.codec.http.CookieEncoder;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.json.JSONObject;

public class EchoHttpService
implements HttpService {
    public static final String NAME = "EchoRequest";

    @Override
    public void handleRequest(Channel connection, Object content, HttpRequest request) {
        this.writeResponse(connection, content, request);
    }

    private void writeResponse(Channel channel, Object content, HttpRequest request) {
        CookieDecoder cookieDecoder;
        Set<Cookie> cookies;
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.setStatus(HttpResponseStatus.OK);
        String cookieString = request.getHeader("Cookie");
        if (cookieString != null && !(cookies = (cookieDecoder = new CookieDecoder()).decode(cookieString)).isEmpty()) {
            CookieEncoder cookieEncoder = new CookieEncoder(true);
            for (Cookie cookie : cookies) {
                cookieEncoder.addCookie(cookie);
            }
            response.addHeader("Set-Cookie", cookieEncoder.encode());
        }
        response.setHeader("Content-Encoding", "UTF-8");
        response.setHeader("Content-Type", "application/json");
        String channelId = String.valueOf(channel.getId());
        HashMap<String, String> dummyContentMap = new HashMap<String, String>();
        dummyContentMap.put("Name", "EchoService");
        dummyContentMap.put("Content", "EchoContent");
        dummyContentMap.put("ChannelId", channelId);
        JSONObject dummyContentObj = new JSONObject(dummyContentMap);
        String dummyContentStr = dummyContentObj.toString();
        ByteBuffer rawContent = ByteBuffer.wrap(dummyContentStr.getBytes());
        rawContent.rewind();
        ChannelBuffer channelBuffer = ChannelBuffers.wrappedBuffer(rawContent);
        response.setHeader("Content-Length", rawContent.limit());
        response.setContent(channelBuffer);
        HttpChannelManager.getInstance().commitResponse(channel, response, false);
    }
}

