/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.decoders;

import com.simba.common.decoder.Decoder;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.common.utils.FrameUtils;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.data.SlotInfo;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class SlotOpenDecoder
implements Decoder {
    public static final String NAME = "SlotOpen";
    protected static final Logger logger = Logger.getLogger(SlotOpenDecoder.class);
    private static final int SLOT_ID_POSITION = 3;

    public static SlotOpenDecoder getDecoderInstance() {
        return SlotFullDecoderHolder.INSTANCE;
    }

    @Override
    public void doDecode(Channel connection, Object message) {
        byte[] content = (byte[])message;
        int slotIdValue = FrameUtils.getInstance().getUnsignedShortBigEndian(3, content);
        String slotKey = String.valueOf(slotIdValue);
        SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(slotKey);
        if (slotInfo == null) {
            return;
        }
        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "open slot " + slotKey, 1));
        SortControllerManager.getInstance().onSlotOpenMessage(slotInfo);
    }

    @Override
    public String getName() {
        return NAME;
    }

    private static class SlotFullDecoderHolder {
        private static final SlotOpenDecoder INSTANCE = new SlotOpenDecoder();

        private SlotFullDecoderHolder() {
        }
    }
}

