/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.decoders;

import com.simba.common.decoder.Decoder;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.common.utils.FrameUtils;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.data.SlotInfo;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class SlotCloseDecoder
implements Decoder {
    public static final String NAME = "SlotClose";
    protected static final Logger logger = Logger.getLogger(SlotCloseDecoder.class);
    private static final int SLOT_ID_POSITION = 3;

    public static SlotCloseDecoder getDecoderInstance() {
        return SlotFullDecoderHolder.INSTANCE;
    }

    @Override
    public void doDecode(Channel connection, Object message) {
        byte[] content = (byte[])message;
        int slotIdValue = FrameUtils.getInstance().getUnsignedShortBigEndian(3, content);
        String slotKey = String.valueOf(slotIdValue);
        SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(slotKey);
        if (slotInfo == null) {
            return;
        }
        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "\u6ed1\u69fd\u5173\u95ed " + slotKey, 1));
        SortControllerManager.getInstance().onSlotCloseMessage(slotInfo);
    }

    @Override
    public String getName() {
        return NAME;
    }

    private static class SlotFullDecoderHolder {
        private static final SlotCloseDecoder INSTANCE = new SlotCloseDecoder();

        private SlotFullDecoderHolder() {
        }
    }
}

