/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.decoders;

import com.simba.common.decoder.Decoder;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.common.utils.FrameUtils;
import com.simba.server.components.PlatInstance;
import com.simba.server.components.PlatInstanceManager;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class PacketOnDecoder
implements Decoder {
    public static final String NAME = "PacketOn";
    protected static final Logger logger = Logger.getLogger(PacketOnDecoder.class);
    private static final int SERIANUMBER__POSITION = 7;
    private static final int PLC_ID_LEN_POSITION = 8;
    private static final int PLC_ID_POSITION = 9;
    private static final int CAR_ID_POSITION = 3;
    private static final int PACKET_ON_MODE_SCANNED = 3;
    private static final int PLAT_ID_POSITION = 5;
    private static final int PLAT_MODE_POSITION = 6;

    public static PacketOnDecoder getDecoderInstance() {
        return PacketOnDecoderHolder.INSTANCE;
    }

    private PacketOnDecoder() {
    }

    @Override
    public void doDecode(Channel connection, Object message) {
        try {
            byte platIdBinary;
            byte[] content = (byte[])message;
            int carIdValue = FrameUtils.getInstance().getUnsignedShortBigEndian(3, content);
            String carId = String.valueOf(carIdValue);
            byte phySicalPlatID = platIdBinary = content[5];
            String platId = String.valueOf(platIdBinary);
            byte modeBinary = content[6];
            String mode = String.valueOf(modeBinary);
            byte serialNumber = content[7];
            String seriaPackCode = String.valueOf(serialNumber);
            byte plcIdLen = content[8];
            String plcIdInfo = new String(content, 9, (int)plcIdLen, "UTF-8");
            PlatInstance platInstance = PlatInstanceManager.getInstance().getPlatById(platId);
            if (platInstance == null) {
                return;
            }
            if (modeBinary == 3) {
                platInstance.handlePacketOnCommand(platId, seriaPackCode, carId, plcIdInfo, mode, "", String.valueOf(phySicalPlatID));
                this.sendPacketEchoToPlc(connection, content);
            } else {
                this.sendErrorPlatModeToPLC();
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "PacketOn Decoder Error : exception info : " + ex.getMessage(), 2));
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    private void sendErrorPlatModeToPLC() {
    }

    private void sendPacketEchoToPlc(Channel channel, byte[] content) {
        if (content == null || content.length < 2) {
            return;
        }
        content[0] = 2;
        content[1] = 1;
        FrameChannelManager.getInstance().commitResponse(channel, content, false);
    }

    private static class PacketOnDecoderHolder {
        private static final PacketOnDecoder INSTANCE = new PacketOnDecoder();

        private PacketOnDecoderHolder() {
        }
    }
}

