/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.decoders;

import com.simba.common.decoder.Decoder;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.PlatInstance;
import com.simba.server.components.PlatInstanceManager;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class PacketMoveDecoder
implements Decoder {
    public static final String NAME = "PacketMove";
    protected static final Logger logger = Logger.getLogger(PacketMoveDecoder.class);
    private static final int PLAT_ID_POSITION = 3;
    private static final int SERIA_ID_POSITION = 4;

    public static PacketMoveDecoder getDecoderInstance() {
        return PacketOnDecoderHolder.INSTANCE;
    }

    private PacketMoveDecoder() {
    }

    @Override
    public void doDecode(Channel connection, Object message) {
        try {
            byte[] content = (byte[])message;
            byte platIdBinary = content[3];
            String platId = String.valueOf(platIdBinary);
            PlatInstance platInstance = PlatInstanceManager.getInstance().getPlatById(platId);
            if (platInstance == null) {
                return;
            }
            byte serialNum = content[4];
            platInstance.sendMovePackageToClient(platId, serialNum);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "PacketMoveDecoder Decoder Error : exception info : " + ex.getMessage(), 2));
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    private void sendErrorPlatModeToPLC() {
    }

    private void sendPacketEchoToPlc(Channel channel, byte[] content) {
        if (content == null || content.length < 2) {
            return;
        }
        content[0] = 2;
        content[1] = 1;
        FrameChannelManager.getInstance().commitResponse(channel, content, false);
    }

    private static class PacketOnDecoderHolder {
        private static final PacketMoveDecoder INSTANCE = new PacketMoveDecoder();

        private PacketOnDecoderHolder() {
        }
    }
}

