/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.decoders;

import com.simba.common.decoder.Decoder;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.data.MachineInfo;
import com.simba.server.framedecoder.FrameDecoderManager;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class MachineStatusDecoder
implements Decoder {
    public static final String NAME = "MachineStatus";
    protected static final Logger logger = Logger.getLogger(MachineStatusDecoder.class);
    private static final int MACHINE_STATUS_POSITION = 3;
    private static final int MECHINE_PAUSE = 3;
    private static final int MECHINE_RUNNING = 5;
    private static final int MECHINE_STARTED = 1;
    private static final int MECHINE_STOPPED = 2;
    private static final int MECHINE_WAIT = 4;

    public static MachineStatusDecoder getMachineStatusDecoder() {
        return MachineStatusDecoderHolder.INSTANCE;
    }

    private MachineStatusDecoder() {
    }

    @Override
    public void doDecode(Channel channel, Object message) {
        try {
            byte[] content = (byte[])message;
            byte machineStatus = content[3];
            MachineInfo machineInfo = new MachineInfo();
            machineInfo.setConnection(FrameDecoderManager.getInstance().getIpAddressFromChannel(channel));
            switch (machineStatus) {
                case 1: {
                    SortControllerManager.getInstance().onMachineStartMessage(machineInfo);
                    break;
                }
                case 2: {
                    SortControllerManager.getInstance().onMachineCloseMessage(machineInfo);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "MachineStatus Decode Catch Exception : " + ex.getMessage(), 2));
        }
    }

    @Override
    public String getName() {
        return null;
    }

    private static class MachineStatusDecoderHolder {
        private static MachineStatusDecoder INSTANCE = new MachineStatusDecoder();

        private MachineStatusDecoderHolder() {
        }
    }
}

