/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder;

import com.simba.common.RequestHandler;
import com.simba.common.decoder.Decoder;
import com.simba.common.decoder.DecoderContainer;
import com.simba.common.decoder.DefaultDecoderContainer;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.common.thread.CommonExecutorFactory;
import com.simba.common.thread.CounterThreadFactory;
import com.simba.server.ServerParam;
import com.simba.server.components.CommonDefines;
import com.simba.server.components.SorterCommonParams;
import com.simba.server.framedecoder.decoders.EchoTimeDecoder;
import com.simba.server.framedecoder.decoders.MachineStatusDecoder;
import com.simba.server.framedecoder.decoders.PacketMoveDecoder;
import com.simba.server.framedecoder.decoders.PacketOffDecoder;
import com.simba.server.framedecoder.decoders.PacketOnDecoder;
import com.simba.server.framedecoder.decoders.QueryTrashSlotDecoder;
import com.simba.server.framedecoder.decoders.SlotCloseDecoder;
import com.simba.server.framedecoder.decoders.SlotFullDecoder;
import com.simba.server.framedecoder.decoders.SlotNormalDecoder;
import com.simba.server.framedecoder.decoders.SlotOpenDecoder;
import com.simba.server.framedecoder.decoders.SlotPackDecoder;
import com.simba.server.framedecoder.decoders.SlotUnlockDecoder;
import com.simba.server.framedecoder.decoders.SorterParamDecoder;
import com.simba.server.framedecoder.decoders.TimeSyncronizedDecoder;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class FrameDecoderManager
implements RequestHandler {
    public static final byte CONNECT_MESSGAE_END = -18;
    public static final byte CONNECT_MESSGAE_HEAD = -1;
    protected static final Logger logger = Logger.getLogger(FrameDecoderManager.class);
    private static int ASYNC_EXECUTOR_POOL_SIZE = 8;
    private static final String ASYNC_OPERATION_EXECUTOR_NAME = "Frame-Decode-Task";
    private Executor asyncDecodeExecutor;
    private BlockingQueue<Runnable> asyncDecodeOperationQueue;
    private final DecoderContainer decoderContainer = new DefaultDecoderContainer();

    public static FrameDecoderManager getInstance() {
        return FrameDecoderManagerHolder.INSTANCE;
    }

    private FrameDecoderManager() {
    }

    public String getIpAddressFromChannel(Channel channel) {
        String addressOrg = channel.getRemoteAddress().toString();
        String sunAddress = addressOrg.substring(1, addressOrg.length());
        String[] splitAddress = sunAddress.split(":");
        return splitAddress[0];
    }

    @Override
    public void handleRequest(final Channel channel, final Object message) {
        Runnable executeRunnable = new Runnable(){

            @Override
            public void run() {
                block4: {
                    try {
                        if (!(message instanceof byte[])) {
                            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "FrameDecoder only can decode byte frame,but message is not instance of byte[].", 3));
                            FrameChannelManager.getInstance().commitResponse(channel, CommonDefines.ERROR_MESSAGE, true);
                            return;
                        }
                        byte[] content = (byte[])message;
                        byte command = content[2];
                        Decoder frameDecoder = FrameDecoderManager.this.getDecoderByCommandNum(command);
                        if (frameDecoder != null) {
                            frameDecoder.doDecode(channel, message);
                        }
                    }
                    catch (Exception ex) {
                        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "FrameDecoderManager catch exception : " + ex.getMessage(), 2));
                        if (!(ex instanceof InterruptedException)) break block4;
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
        if (SorterCommonParams.getInstance().isNewThreadEachRequest()) {
            this.executeInNewThread(executeRunnable);
        } else {
            this.executeInThreadPool(executeRunnable);
        }
    }

    @Override
    public void onChannelConnected(Channel channel) {
    }

    @Override
    public void onChannelDisconnected(Channel channel) {
    }

    public void init() {
        this.initAsyncTaskExcutor();
        this.initDecoderContainer();
    }

    public void postInitProcess() {
        String requestMode = "Request In New Thread";
        if (!SorterCommonParams.getInstance().isNewThreadEachRequest()) {
            requestMode = "Request In Thread Pool";
        }
        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "FrameDecoderManager initialize successfully, Pool size:[" + ASYNC_EXECUTOR_POOL_SIZE + "] reqeust mode:[" + requestMode + "]", 3));
    }

    private void executeInNewThread(Runnable executeRunnable) {
        new Thread(executeRunnable).start();
    }

    private void executeInThreadPool(Runnable executeRunnable) {
        this.runAsyncDecodeTask(executeRunnable);
    }

    private Decoder getDecoderByCommandNum(byte command) {
        Decoder frameDecoder = null;
        switch (command) {
            case 1: {
                frameDecoder = this.decoderContainer.getDecoder("MachineStatus");
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                frameDecoder = this.decoderContainer.getDecoder("PacketOn");
                break;
            }
            case 8: {
                frameDecoder = this.decoderContainer.getDecoder("PacketOff");
                break;
            }
            case 11: {
                frameDecoder = this.decoderContainer.getDecoder("SorterParam");
                break;
            }
            case 32: {
                frameDecoder = this.decoderContainer.getDecoder("PacketMove");
                break;
            }
            case 65: {
                frameDecoder = this.decoderContainer.getDecoder("SlotOpen");
                break;
            }
            case 66: {
                frameDecoder = this.decoderContainer.getDecoder("SlotClose");
                break;
            }
            case 67: {
                frameDecoder = this.decoderContainer.getDecoder("SlotNormal");
                break;
            }
            case 68: {
                frameDecoder = this.decoderContainer.getDecoder("SlotFull");
                break;
            }
            case 69: {
                frameDecoder = this.decoderContainer.getDecoder("SlotUnlock");
                break;
            }
            case 70: {
                frameDecoder = this.decoderContainer.getDecoder("SlotPack");
                break;
            }
        }
        return frameDecoder;
    }

    private void initAsyncTaskExcutor() {
        if (ServerParam.DECODER_THREAD_POOL_SIZE > 0) {
            ASYNC_EXECUTOR_POOL_SIZE = ServerParam.DECODER_THREAD_POOL_SIZE;
        }
        this.asyncDecodeOperationQueue = new LinkedBlockingQueue<Runnable>();
        this.asyncDecodeExecutor = CommonExecutorFactory.newFixedThreadPool(ASYNC_EXECUTOR_POOL_SIZE, new CounterThreadFactory(ASYNC_OPERATION_EXECUTOR_NAME), this.asyncDecodeOperationQueue);
    }

    private void initDecoderContainer() {
        this.decoderContainer.addDecoder("PacketOff", PacketOffDecoder.getDecoderInstance());
        this.decoderContainer.addDecoder("PacketOn", PacketOnDecoder.getDecoderInstance());
        this.decoderContainer.addDecoder("MachineStatus", MachineStatusDecoder.getMachineStatusDecoder());
        this.decoderContainer.addDecoder("SorterParam", SorterParamDecoder.getSorterParamDecoder());
        this.decoderContainer.addDecoder("SlotPack", SlotPackDecoder.getDecoderInstance());
        this.decoderContainer.addDecoder("SlotUnlock", SlotUnlockDecoder.getDecoderInstance());
        this.decoderContainer.addDecoder("EchoTime", EchoTimeDecoder.getInstance());
        this.decoderContainer.addDecoder("QueryTrashSlot", QueryTrashSlotDecoder.getInstance());
        this.decoderContainer.addDecoder("TImeSync", new TimeSyncronizedDecoder());
        this.decoderContainer.addDecoder("SlotNormal", SlotNormalDecoder.getDecoderInstance());
        this.decoderContainer.addDecoder("SlotFull", SlotFullDecoder.getDecoderInstance());
        this.decoderContainer.addDecoder("PacketMove", PacketMoveDecoder.getDecoderInstance());
        this.decoderContainer.addDecoder("SlotOpen", SlotOpenDecoder.getDecoderInstance());
        this.decoderContainer.addDecoder("SlotClose", SlotCloseDecoder.getDecoderInstance());
    }

    private void runAsyncDecodeTask(Runnable task) {
        try {
            if (task != null) {
                this.asyncDecodeExecutor.execute(task);
            }
        }
        catch (Exception e) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Run async task to decode failed : " + e.getMessage(), 2));
        }
    }

    private static class FrameDecoderManagerHolder {
        private static final FrameDecoderManager INSTANCE = new FrameDecoderManager();

        private FrameDecoderManagerHolder() {
        }
    }
}

