/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.delimterdecoder.services;

import com.simba.common.jsonservice.JsonService;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.ServerManager;
import com.simba.server.components.OrderManager;
import com.simba.server.components.data.ReturnPackageInfo;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReturnRecJsonService
implements JsonService {
    public static final String NAME = "RejectGoods";
    private static final int CHECK_TIME_BUFFER_SIZE = 14;
    private static final Logger logger = Logger.getLogger(ReturnRecJsonService.class);

    @Override
    public void handleRequest(Channel channel, Object content) {
        try {
            OrderManager.getInstance().responseAck(channel);
            JSONObject request = (JSONObject)content;
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "get return info : " + request.toString(), 1));
            String name = request.getString("ServiceName");
            if (name == null || !name.equals(NAME)) {
                return;
            }
            String BatchNumber = request.getString("BatchNumber");
            LinkedList<ReturnPackageInfo> returnList = new LinkedList<ReturnPackageInfo>();
            JSONArray sku = request.getJSONArray("Skus");
            if (sku.length() > 0) {
                for (int i = 0; i < sku.length(); ++i) {
                    JSONObject jObject = sku.getJSONObject(i);
                    ReturnPackageInfo returnPackageInfo = new ReturnPackageInfo();
                    returnPackageInfo.setSkuBarcode(jObject.getString("Sku"));
                    returnPackageInfo.setSkuNumber(jObject.getInt("SkuNum"));
                    returnPackageInfo.setItemName(jObject.getString("ItemName"));
                    returnPackageInfo.setLogicSlot(jObject.getString("LogicSlot"));
                    returnPackageInfo.setBatchCode(BatchNumber);
                    returnList.add(returnPackageInfo);
                }
            }
            if (returnList.size() > 0) {
                ServerManager.getInstance().getReturnRestoreTask().offerReturnListToQueue(returnList);
            }
        }
        catch (JSONException ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "return rec Service Error : exception info : ", 2));
        }
    }
}

