/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.delimterdecoder.services;

import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.jsonservice.JsonService;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.ServerManager;
import com.simba.server.components.CommonDefines;
import com.simba.server.components.OrderManager;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.OrderInfo;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OrderRecJsonService
implements JsonService {
    public static final String NAME = "OrderInfo";
    private static final int CHECK_TIME_BUFFER_SIZE = 14;
    private static final Logger logger = Logger.getLogger(OrderRecJsonService.class);

    @Override
    public void handleRequest(Channel channel, Object content) {
        try {
            OrderManager.getInstance().responseAck(channel);
            JSONObject request = (JSONObject)content;
            String name = request.getString("ServiceName");
            if (name == null || !name.equals(NAME)) {
                return;
            }
            String waveID = request.getString("WaveID");
            String TaskID = request.getString("TaskID");
            LinkedList<OrderInfo> orderLists = new LinkedList<OrderInfo>();
            JSONArray lpns = request.getJSONArray("Lpns");
            if (lpns.length() > 0) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date dnow = new Date();
                dnow.setTime(dnow.getTime());
                String strCruTime = df.format(dnow);
                Timestamp curTime = Timestamp.valueOf(strCruTime);
                for (int i = 0; i < lpns.length(); ++i) {
                    JSONObject jObject = lpns.getJSONObject(i);
                    OrderInfo orderInfo = new OrderInfo();
                    orderInfo.setLpn(jObject.getString("Lpn"));
                    orderInfo.setSkuID(jObject.getString("Sku"));
                    orderInfo.setSkuBarcode(jObject.getString("SkuBrcd"));
                    orderInfo.setSkuQty(jObject.getInt("SkuQty"));
                    orderInfo.setLpnQty(jObject.getInt("LpnQty"));
                    String lockMode = "N";
                    if (jObject.has("LockMode")) {
                        lockMode = jObject.getString("LockMode");
                    }
                    orderInfo.setLockMode(lockMode);
                    double lpnWeight = jObject.getDouble("LpnWeight");
                    int isCanelOrder = 0;
                    orderInfo.setIsCancelOrder(isCanelOrder);
                    orderInfo.setLpnWeight(lpnWeight);
                    orderInfo.setWaveID(waveID);
                    orderInfo.setTaskID(TaskID);
                    String key = TaskID + "-" + orderInfo.getLpn() + "-" + orderInfo.getSkuBarcode();
                    if (OrderManager.getInstance().getTaskLpnSkuMap().containsKey(key)) continue;
                    orderLists.add(orderInfo);
                    OrderManager.getInstance().getTaskLpnSkuMap().put(key, curTime);
                }
            }
            ServerManager.getInstance().getOrderRestoreTask().offerOrderListToQueue(orderLists);
        }
        catch (JSONException ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "order rec Service Error : exception info : ", 2));
        }
    }

    private void sendTimeToPlc() {
        try {
            Channel[] channels;
            byte[] replyBuffer = new byte[14];
            int position = 0;
            byte[] header = CommonDefines.REPLY_HEADER;
            System.arraycopy(header, 0, replyBuffer, position, header.length);
            byte[] command = new byte[]{17};
            System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
            byte[] timeBuffer = SorterProtocolCreator.getInstance().createSystemTimeToBuffer();
            System.arraycopy(timeBuffer, 0, replyBuffer, position += command.length, timeBuffer.length);
            byte[] serialByte = new byte[]{1};
            System.arraycopy(serialByte, 0, replyBuffer, position += timeBuffer.length, serialByte.length);
            byte[] replayEnder = CommonDefines.REPLY_ENDER;
            System.arraycopy(replayEnder, 0, replyBuffer, position += serialByte.length, replayEnder.length);
            position += replayEnder.length;
            for (Channel channel : channels = FrameChannelManager.getInstance().getChannelList()) {
                FrameChannelManager.getInstance().commitResponse(channel, replyBuffer, false);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "EchoTime Decode Catch Exception : " + ex.getMessage(), 2));
        }
    }
}

