/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.delimterdecoder.services;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.jsonservice.JsonService;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.OrderManager;
import com.simba.server.components.data.LpnInfo;
import java.sql.Timestamp;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONException;
import org.json.JSONObject;

public class OrderCheckedJsonService
implements JsonService {
    public static final String NAME = "OrderCheck";
    private static final Logger logger = Logger.getLogger(OrderCheckedJsonService.class);

    @Override
    public void handleRequest(Channel channel, Object content) {
        try {
            JSONObject request = (JSONObject)content;
            String name = request.getString("ServiceName");
            if (name == null || !name.equals(NAME)) {
                return;
            }
            OrderManager.getInstance().responseAck(channel);
            String lpn = request.getString("Lpn");
            String wayBill = request.getString("WayBill");
            int wayDirection = request.getInt("WayDirection");
            String deliverName = request.getString("DeliverName");
            String opTime = request.getString("OpTime");
            LpnInfo lpnInfo = new LpnInfo();
            lpnInfo.setLpn(lpn);
            lpnInfo.setWayBill(wayBill);
            lpnInfo.setDwsSlot(wayDirection);
            lpnInfo.setDeliverName(deliverName);
            lpnInfo.setOrderCheckedTime(Timestamp.valueOf(opTime));
            this.updateLpnWayBill(lpnInfo);
        }
        catch (JSONException ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "OrderCheckedJsonService  Error : exception info : ", 2));
        }
    }

    private void updateLpnWayBill(LpnInfo lpnInfo) {
        ICommand command = CommandCreator.getInstance().createCommand("UpdateLpnWaybill", lpnInfo);
        Boolean res = SQLCommandExecutor.getInstance().executeCmd(command);
        if (!res.booleanValue()) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "updateLpnWayBill failed lpn=" + lpnInfo.getLpn(), 2));
        }
    }
}

