/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.OrderManager;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.components.data.UploadReturnSkuInfo;
import com.simba.server.controllers.ISlotPackController;
import com.simba.server.netclient.DefaultClientManager;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class LuolaiSlotPackController
implements ISlotPackController {
    private static final Logger logger = Logger.getLogger(LuolaiSlotPackController.class);

    @Override
    public void onSlotPackMessage(SlotInfo slotInfo) {
        if (slotInfo == null) {
            return;
        }
        String packCode = slotInfo.getPackCode();
        if (packCode == null || packCode.length() < 10) {
            return;
        }
        long curTime = SorterProtocolCreator.getInstance().createCurrentTimeStamp().getTime();
        slotInfo.setOpID(curTime);
        this.handleSlotLock(slotInfo);
        slotInfo.setPackCode(SlotManager.getInstance().createSlotBindUUID());
        SlotManager.getInstance().updateSlotStatus(slotInfo);
        if (slotInfo.getSortInfoMode().equalsIgnoreCase("back")) {
            this.handleReturnSkuMsgToMa(slotInfo);
        }
    }

    private void handleReturnSkuMsgToMa(SlotInfo slotInfo) {
        try {
            UploadReturnSkuInfo uploadReturnSkuInfo = new UploadReturnSkuInfo();
            uploadReturnSkuInfo.setSlotId(Integer.parseInt(slotInfo.getSlotId()));
            this.handleReturnSkuInfo(uploadReturnSkuInfo);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handleSkuMsgToMa Error -- Exception : " + ex, 2));
        }
    }

    private void handleReturnSkuInfo(UploadReturnSkuInfo uploadReturnSkuInfo) {
        ICommand command = CommandCreator.getInstance().createCommand("FetchReturnSkuInfoCmd", uploadReturnSkuInfo);
        boolean res = SQLCommandExecutor.getInstance().executeCmd(command);
        if (res) {
            String msg = SorterProtocolCreator.getInstance().createReturnSkuMsg(uploadReturnSkuInfo);
            boolean s = DefaultClientManager.getInstance().sendUploadMsgToStoClient(msg.getBytes());
            if (s) {
                LinkedList<Long> idList = new LinkedList<Long>();
                Map<String, UploadReturnSkuInfo> returnSkuMap = uploadReturnSkuInfo.getUploadReturnSkuMap();
                for (Map.Entry<String, UploadReturnSkuInfo> entry : returnSkuMap.entrySet()) {
                    UploadReturnSkuInfo skuInfo = entry.getValue();
                    idList.add(skuInfo.getId());
                }
                this.handleOffStatusInfo(idList);
            }
        }
    }

    private void handleOffStatusInfo(List<Long> idList) {
        ICommand command = CommandCreator.getInstance().createCommand("UpdateOffStatusCmd", idList);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }

    private void handleSlotLock(SlotInfo slotInfo) {
        try {
            slotInfo.setIsLocked(1);
            OrderManager.getInstance().senSlotLightoPlc(slotInfo);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handleSlotLock Error -- Exception : " + ex, 2));
        }
    }

    private void updateStoPacketSlotStatus(String strPackCode) {
        ICommand command = CommandCreator.getInstance().createCommand("STOSlotPackUpdate", strPackCode);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }
}

