/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.luolai;

import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.OrderManager;
import com.simba.server.components.SlotManager;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.controllers.ISlotOpenController;
import org.apache.log4j.Logger;

public class LuolaiSlotOpenController
implements ISlotOpenController {
    private static final Logger logger = Logger.getLogger(LuolaiSlotOpenController.class);

    private void handleSlotMsgToMa(SlotInfo slotInfo) {
        try {
            OrderManager.getInstance().handleLpnFinish(slotInfo);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handleSlotMsgToMa Error -- Exception : " + ex, 2));
        }
    }

    private void resetSlotInfo(SlotInfo slotInfo) {
        try {
            slotInfo.setLpn("");
            slotInfo.setMailCount(0);
            slotInfo.getSkuMap().clear();
            slotInfo.setPackCode(SlotManager.getInstance().createSlotBindUUID());
            slotInfo.setLpnTaskInProcess(0);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "resetSlotInfo Error -- Exception : " + ex, 2));
        }
    }

    @Override
    public void onSlotOpenMessage(SlotInfo slotInfo) {
        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), " \u6ed1\u69fd\u6253\u5f00 " + slotInfo.getSlotId(), 1));
        slotInfo.setIsOpen(1);
        if (slotInfo.getLpnStatus() > 0) {
            this.handleSlotMsgToMa(slotInfo);
        }
        this.resetSlotInfo(slotInfo);
        OrderManager.getInstance().senSlotLightoPlc(slotInfo);
        SlotManager.getInstance().updateSlotStatus(slotInfo);
    }
}

