/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.OrderManager;
import com.simba.server.components.PlatInstance;
import com.simba.server.components.PlatInstanceManager;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.components.data.SortInfo;
import com.simba.server.controllers.IScannedController;
import com.simba.server.controllers.luolai.LuolaiCommonParams;
import com.simba.server.netclient.DefaultClientManager;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class LuolaiScannedController
implements IScannedController {
    private static final Logger logger = Logger.getLogger(LuolaiScannedController.class);

    @Override
    public void onScannedMessage(SortInfo sortInfo) {
        this.requestStoSortInfo(sortInfo);
    }

    private void handleSendScanMsgToMonitor(SortInfo sortInfo) {
        try {
            String strMsgContent = SorterProtocolCreator.getInstance().createScanMsg(sortInfo);
            byte[] content = strMsgContent.getBytes();
            DefaultClientManager.getInstance().sendUploadMsgToStoClient(content);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handleSendScanMsgToMonitor Error -- Exception : " + ex, 2));
        }
    }

    private void handleDepartureSortInfo(SortInfo sortInfo) {
        try {
            JSONObject dataObj = sortInfo.getDataObj();
            dataObj.put("stoMode", "departure");
            ICommand command = CommandCreator.getInstance().createCommand("FetchSkuOrderInfoD", sortInfo);
            Boolean res = SQLCommandExecutor.getInstance().executeCmd(command);
            SlotInfo slot = null;
            slot = Integer.parseInt(sortInfo.getPlatId()) <= 3 ? SlotManager.getInstance().getDeliverSlotInfoByLpn(sortInfo) : SlotManager.getInstance().getDeliverSlotInfoByLpnSpecial(sortInfo);
            String platId = sortInfo.getPlatId();
            PlatInstance platInstance = PlatInstanceManager.getInstance().getPlatById(platId);
            if (res.booleanValue()) {
                if (platInstance == null) {
                    return;
                }
                if (slot == null) {
                    this.handleNoSlotSortInfo(sortInfo);
                } else {
                    platInstance.setPacketSerial(sortInfo);
                    slot.setLpn(sortInfo.getOrderInfo().getLpn());
                    slot.setLpnQty(sortInfo.getOrderInfo().getLpnQty());
                    sortInfo.getSlotsList().add(Integer.parseInt(slot.getSlotId()));
                    this.handleNormalSortInfo(sortInfo);
                    this.updateScanQty(sortInfo);
                }
            } else {
                platInstance.setPacketSerial(sortInfo);
                this.handleNoInfoSortInfo(sortInfo);
            }
            this.sendStoSortInfoToClient(sortInfo);
            String strKey = sortInfo.getOrderInfo().getLpn() + "-" + sortInfo.getOrderInfo().getSkuBarcode();
            if (OrderManager.getInstance().getSkuLpnScanMap().containsKey(strKey)) {
                OrderManager.getInstance().getSkuLpnScanMap().remove(strKey);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle handleDepartureSortInfo Error -- Exception : " + ex, 2));
        }
    }

    private void updateScanQty(SortInfo sortInfo) {
        try {
            ICommand command = CommandCreator.getInstance().createCommand("UpdateOrderScan", sortInfo);
            SQLCommandExecutor.getInstance().executeCmd(command);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "UpdateOrderScan Error : " + sortInfo.getBarcode(), 3));
        }
    }

    private void handleReturnSortInfo(SortInfo sortInfo) {
        try {
            ICommand command = CommandCreator.getInstance().createCommand("FetchReturnLocationCmd", sortInfo);
            Boolean res = SQLCommandExecutor.getInstance().executeCmd(command);
            if (res.booleanValue()) {
                if (this.handleReturnSlot(sortInfo)) {
                    this.sendStoSortInfoToPLC(sortInfo);
                } else {
                    this.handleNoSortPlanSortInfo(sortInfo);
                }
            } else {
                this.handleNoInfoSortInfo(sortInfo);
            }
            this.sendStoSortInfoToClient(sortInfo);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle handleReturnSortInfo Error -- Exception : " + ex, 2));
        }
    }

    private boolean handleReturnSlot(SortInfo sortInfo) {
        boolean res = false;
        try {
            ICommand command = CommandCreator.getInstance().createCommand("FetchReturnSlotCmd", sortInfo);
            res = SQLCommandExecutor.getInstance().executeCmd(command);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handleReturnSlot Error : " + sortInfo.getLocation(), 3));
        }
        return res;
    }

    private void handleNormalSortInfo(SortInfo sortInfo) {
        try {
            sortInfo.setDroppedErrorCode(0);
            sortInfo.setServerErrorCode(0);
            JSONObject dataObject = sortInfo.getDataObj();
            this.sendStoSortInfoToPLC(sortInfo);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle  handleNormalSortInfo Error -- Exception : " + ex, 2));
        }
    }

    private void handleNoInfoSortInfo(SortInfo sortInfo) {
        try {
            sortInfo.setServerErrorCode(1);
            if (LuolaiCommonParams.getInstance().getIsUseVC() == 0) {
                List<String> noInfoSlots = SlotManager.getInstance().getNoInfoTrashSlots();
                sortInfo.getSlotsList().clear();
                for (String trashSlot : noInfoSlots) {
                    sortInfo.getSlotsList().add(Integer.parseInt(trashSlot));
                }
            }
            this.sendStoSortInfoToPLC(sortInfo);
            JSONObject dataObj = sortInfo.getDataObj();
            dataObj.put("msg", "trashSlot");
            dataObj.put("exceptionCode", "1");
            sortInfo.setDataObj(dataObj);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle  handleNoInfoSortInfo Error -- Exception : " + ex, 2));
        }
    }

    private void handleNoSlotSortInfo(SortInfo sortInfo) {
        try {
            sortInfo.setServerErrorCode(2);
            List<String> noPlanSlots = SlotManager.getInstance().getNoPlanTrashSlots();
            sortInfo.getSlotsList().clear();
            for (String trashSlot : noPlanSlots) {
                sortInfo.getSlotsList().add(Integer.parseInt(trashSlot));
            }
            JSONObject dataObj = sortInfo.getDataObj();
            dataObj.put("msg", "trashSlot");
            dataObj.put("exceptionCode", "2");
            if (!sortInfo.getFindSlotStatus().equalsIgnoreCase("nofree")) {
                this.sendStoSortInfoToPLC(sortInfo);
                dataObj.put("exceptionCode", "3");
            }
            sortInfo.setDataObj(dataObj);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle  handleNoSortPlanSortInfo Error -- Exception : " + ex, 2));
        }
    }

    private void handleNoSortPlanSortInfo(SortInfo sortInfo) {
        try {
            sortInfo.setServerErrorCode(2);
            List<String> noPlanSlots = SlotManager.getInstance().getNoPlanTrashSlots();
            sortInfo.getSlotsList().clear();
            for (String trashSlot : noPlanSlots) {
                sortInfo.getSlotsList().add(Integer.parseInt(trashSlot));
            }
            this.sendStoSortInfoToPLC(sortInfo);
            JSONObject dataObj = sortInfo.getDataObj();
            dataObj.put("msg", "trashSlot");
            dataObj.put("exceptionCode", "2");
            sortInfo.setDataObj(dataObj);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle  handleNoSortPlanSortInfo Error -- Exception : " + ex, 2));
        }
    }

    private void handleInterceptSortInfo(SortInfo sortInfo) {
        try {
            if (sortInfo.getServerErrorCode() == 0) {
                sortInfo.setServerErrorCode(5);
            }
            List<String> interceptSlots = SlotManager.getInstance().getInterCeptSlots();
            sortInfo.getSlotsList().clear();
            for (String trashSlot : interceptSlots) {
                sortInfo.getSlotsList().add(Integer.parseInt(trashSlot));
            }
            this.sendStoSortInfoToPLC(sortInfo);
            JSONObject dataObj = sortInfo.getDataObj();
            dataObj.put("msg", "copy");
            dataObj.put("exceptionCode", "5");
            sortInfo.setDataObj(dataObj);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle  handleInterceptSortInfo Error -- Exception : " + ex, 2));
        }
    }

    private void requestStoSortInfo(SortInfo sortInfo) {
        try {
            if (sortInfo.getOrderMode().equals("order")) {
                this.handleDepartureSortInfo(sortInfo);
            } else {
                this.handleReturnSortInfo(sortInfo);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Sto Handle Sort Info Error : " + sortInfo.getBarcode(), 3));
        }
    }

    private void restoreScanInfo(SortInfo sortInfo) {
        try {
            ICommand command = CommandCreator.getInstance().createCommand("STOScanned", sortInfo);
            SQLCommandExecutor.getInstance().executeCmd(command);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "restoreScanInfo Error : " + sortInfo.getBarcode(), 3));
        }
    }

    private void sendStoSortInfoToPLC(SortInfo sortInfo) {
        Channel[] clients;
        byte[] replyBuffer = SorterProtocolCreator.getInstance().createSortInfoWithPlat(sortInfo);
        for (Channel client : clients = FrameChannelManager.getInstance().getChannelList()) {
            FrameChannelManager.getInstance().commitResponse(client, replyBuffer, false);
        }
    }

    private void sendStoSortInfoToClient(SortInfo sortInfo) {
        String platId = sortInfo.getPlatId();
        PlatInstance plat = PlatInstanceManager.getInstance().getPlatById(platId);
        String strResponse = this.getScanResponse(sortInfo);
        if (plat != null) {
            JsonChannelManager.getInstance().commitResponse(plat.getPlatClient(), strResponse.getBytes(), false);
        }
    }

    private String getScanResponse(SortInfo sortInfo) {
        JSONObject sortInfoObj = new JSONObject();
        sortInfoObj.put("ServiceName", "SortResult");
        String slots = "";
        if (sortInfo.getSlotsList().size() > 0) {
            for (int slot : sortInfo.getSlotsList()) {
                slots = slots + String.valueOf(slot) + "|";
            }
        }
        JSONObject dataObj = sortInfo.getDataObj();
        String strMsg = "";
        if (!dataObj.isNull("msg")) {
            strMsg = dataObj.get("msg").toString();
        }
        String strExceptionCode = "0";
        if (!dataObj.isNull("exceptionCode")) {
            strExceptionCode = dataObj.get("exceptionCode").toString();
        }
        if (!slots.equalsIgnoreCase("")) {
            sortInfoObj.put("factualSlot", slots.substring(0, slots.length() - 1));
        } else {
            sortInfoObj.put("factualSlot", "0");
        }
        sortInfoObj.put("packageCode", sortInfo.getPackCode());
        sortInfoObj.put("barcode", sortInfo.getBarcode());
        sortInfoObj.put("weight", sortInfo.getWeight());
        sortInfoObj.put("exceptionCode", strExceptionCode);
        sortInfoObj.put("isNeedVideo", sortInfo.getIsNeedVideoCoding());
        sortInfoObj.put("sortModel", sortInfo.getPlatMode());
        sortInfoObj.put("scanSeriaNum", sortInfo.getPacketSerialNo());
        sortInfoObj.put("msg", strMsg);
        return sortInfoObj.toString();
    }
}

