/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.OrderManager;
import com.simba.server.components.SlotManager;
import com.simba.server.components.data.OrderInfo;
import com.simba.server.components.data.SortInfo;
import com.simba.server.controllers.IPacketOnController;
import org.apache.log4j.Logger;

public class LuolaiPacketOnController
implements IPacketOnController {
    private static final Logger logger = Logger.getLogger(LuolaiPacketOnController.class);

    @Override
    public void onPacketOnMessage(SortInfo sortInfo) {
        try {
            this.updateOrderStatus(sortInfo);
            this.restoreStoPacketOnInfo(sortInfo);
            this.removePackonLpnSku(sortInfo);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle Sto Packet On Message In PacketOnController Handler Error -- Exception : " + ex, 2));
        }
    }

    private void updateOrderStatus(SortInfo sortInfo) {
        if (SlotManager.getInstance().checkSlotIsTrash(String.valueOf(sortInfo.getSlotsList().get(0))).booleanValue()) {
            return;
        }
        ICommand command = CommandCreator.getInstance().createCommand("UpdateOrderPackOn", sortInfo);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }

    private void restoreStoPacketOnInfo(SortInfo sortInfo) {
        ICommand command = CommandCreator.getInstance().createCommand("AddPacketOn", sortInfo);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }

    private void removePackonLpnSku(SortInfo sortInfo) {
        OrderInfo orderInfo = sortInfo.getOrderInfo();
        String strKey = orderInfo.getLpn() + "-" + sortInfo.getBarcode();
        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "delete last sku : " + strKey, 1));
        if (OrderManager.getInstance().getPackOnSkuLpnMap().containsKey(strKey)) {
            OrderManager.getInstance().getPackOnSkuLpnMap().remove(strKey);
        }
    }
}

