/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.OrderManager;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.LpnInfo;
import com.simba.server.components.data.OrderInfo;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.components.data.SortInfo;
import com.simba.server.controllers.IPacketOffController;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class LuolaiPacketOffController
implements IPacketOffController {
    private static final Logger logger = Logger.getLogger(LuolaiPacketOffController.class);

    @Override
    public void onPacketOffMessage(SortInfo sortInfo) {
        try {
            this.restoreStoPacketOffInfo(sortInfo);
            if (sortInfo.getOrderMode().equalsIgnoreCase("order")) {
                this.handleDepPackCode(sortInfo);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle Packet Off Message In STOPacketOffController Handler Error -- Exception : " + ex, 2));
        }
    }

    private void handleDepPackCode(SortInfo sortInfo) {
        try {
            int droppedSlotId = sortInfo.getDroppedSlotId();
            String slotId = String.valueOf(droppedSlotId);
            SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(slotId);
            if (slotInfo == null) {
                return;
            }
            int mailCount = slotInfo.getMailCount();
            slotInfo.setLpnTaskInProcess(1);
            OrderInfo orderInfo = sortInfo.getOrderInfo();
            slotInfo.setTotalWeight(orderInfo.getLpnWeight());
            if (mailCount == 1) {
                Timestamp beginLpnTime = SorterProtocolCreator.getInstance().createCurrentTimeStamp();
                slotInfo.setBeginTime(beginLpnTime);
                if (sortInfo.getOrderMode().equalsIgnoreCase("order")) {
                    LpnInfo lpnInfo = new LpnInfo();
                    lpnInfo.setLpn(orderInfo.getLpn());
                    this.fetchLpnInfos(lpnInfo);
                    slotInfo.setLpn(orderInfo.getLpn());
                    slotInfo.setLpnQty(orderInfo.getLpnQty());
                    slotInfo.setSkuMap(lpnInfo.getSkuMap());
                    this.addLpnRecord(slotInfo);
                    this.AddLpnStatus(slotInfo);
                }
            } else {
                this.updateLpnRecord(slotInfo);
            }
            slotInfo.setMailCount(mailCount);
            int lpnQty = orderInfo.getLpnQty();
            if (slotInfo.getSkuMap().containsKey(orderInfo.getSkuBarcode())) {
                OrderInfo order = slotInfo.getSkuMap().get(orderInfo.getSkuBarcode());
                order.setPackOffQty(order.getPackOffQty() + 1);
                slotInfo.getSkuMap().put(orderInfo.getSkuBarcode(), order);
            }
            if (mailCount >= lpnQty) {
                slotInfo.setLpnStatus(1);
                OrderManager.getInstance().removeLpn(slotInfo);
                slotInfo.setDeleteOrder(true);
            }
            OrderManager.getInstance().senSlotLightoPlc(slotInfo);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handle departure packageCode Error -- Exception : " + ex, 2));
        }
    }

    private boolean fetchLpnInfos(LpnInfo lpnInfo) {
        boolean ret = false;
        ICommand command = CommandCreator.getInstance().createCommand("FetchLpnInfo", lpnInfo);
        ret = SQLCommandExecutor.getInstance().executeCmd(command);
        if (!ret) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "fetchLpnInfos fail: " + lpnInfo.getLpn(), 2));
        }
        return ret;
    }

    private void addLpnRecord(SlotInfo slotInfo) {
        ICommand command = CommandCreator.getInstance().createCommand("LpnStatusInsert", slotInfo);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }

    private void AddLpnStatus(SlotInfo slotInfo) {
        ICommand command = CommandCreator.getInstance().createCommand("AddLpnStatus", slotInfo);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }

    private void updateLpnRecord(SlotInfo slotInfo) {
        ICommand command = CommandCreator.getInstance().createCommand("UpdateLpnActQty", slotInfo);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }

    private void restoreStoPacketOffInfo(SortInfo sortInfo) {
        ICommand command = CommandCreator.getInstance().createCommand("AddPacketOff", sortInfo);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }
}

