/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components.task;

import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.SlotManager;
import com.simba.server.components.data.StaticInfo;
import com.simba.server.controllers.luolai.LuolaiCommonParams;
import java.net.InetAddress;
import java.net.NetworkInterface;
import org.apache.log4j.Logger;

public class SortResultStaticTask
extends Thread {
    private static final Logger logger = Logger.getLogger(SortResultStaticTask.class);
    private static final int REQUEST_INTERVAL = 600000;
    private static String strMacAddr = "";

    public static SortResultStaticTask getInstance() {
        return SortResultStaticTaskHolder.INSTANCE;
    }

    public SortResultStaticTask() {
        this.setName("Sort-Result-Static-Task");
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(600000L);
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch an exception [" + ex.getMessage() + "]", 2));
            }
        }
    }

    private void doHandleResetIntercept() {
        SlotManager.getInstance().initTrashSlots();
    }

    private void doHandlePlatStatic() {
    }

    private StaticInfo createStaticInfo(int platID, int packNumber) {
        StaticInfo staticInfo = new StaticInfo();
        staticInfo.setSiteCode(LuolaiCommonParams.getInstance().getStoSiteCode());
        staticInfo.setSupplierID(LuolaiCommonParams.getInstance().getStoSupplierID());
        if (strMacAddr.equalsIgnoreCase("")) {
            strMacAddr = this.getLocalMac();
        }
        staticInfo.setDeviceID(strMacAddr);
        staticInfo.setDeviceType("1");
        staticInfo.setNumbers(packNumber);
        staticInfo.setPlatID(platID);
        int supplierType = Integer.parseInt(LuolaiCommonParams.getInstance().getStoSupplierType());
        staticInfo.setSupplierType(supplierType);
        return staticInfo;
    }

    private String getLocalMac() {
        String strMacAddr = "";
        try {
            InetAddress ia = InetAddress.getLocalHost();
            byte[] mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < mac.length; ++i) {
                int temp;
                String str;
                if (i != 0) {
                    sb.append("-");
                }
                if ((str = Integer.toHexString(temp = mac[i] & 0xFF)).length() == 1) {
                    sb.append("0" + str);
                    continue;
                }
                sb.append(str);
            }
            strMacAddr = sb.toString().toUpperCase();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strMacAddr;
    }

    private static class SortResultStaticTaskHolder {
        private static final SortResultStaticTask INSTANCE = new SortResultStaticTask();

        private SortResultStaticTaskHolder() {
        }
    }
}

