/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components.task;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.data.ReturnPackageInfo;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class ReturnInfoResotreMysqlTask
extends Thread {
    private static final Logger logger = Logger.getLogger(ReturnInfoResotreMysqlTask.class);
    private final BlockingQueue<List<ReturnPackageInfo>> returnInfoListQueue = new LinkedBlockingQueue<List<ReturnPackageInfo>>();
    private static final int REQUEST_INTERVAL = 10000;

    public ReturnInfoResotreMysqlTask() {
        this.setName("Return-Info-Resotre-Mysql-Task");
    }

    public void offerReturnListToQueue(List<ReturnPackageInfo> ReturnInfolist) {
        if (ReturnInfolist == null) {
            return;
        }
        this.returnInfoListQueue.offer(ReturnInfolist);
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(10000L);
                this.updateReturnInfoList();
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch an exception [" + ex.getMessage() + "]", 2));
            }
        }
    }

    protected void updateReturnInfoList() throws InterruptedException {
        List<ReturnPackageInfo> ReturnInfolist = this.returnInfoListQueue.take();
        if (ReturnInfolist.size() > 0) {
            ICommand command = CommandCreator.getInstance().createCommand("AddReturnPackageInfo", ReturnInfolist);
            Boolean res = SQLCommandExecutor.getInstance().executeCmd(command);
            if (!res.booleanValue()) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "insert ReturnInfo failed", 2));
            }
        }
    }
}

