/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components.task;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SlotManager;
import com.simba.server.components.data.SlotInfo;
import org.apache.log4j.Logger;

public class PollModeTask
extends Thread {
    private static final Logger logger = Logger.getLogger(PollModeTask.class);
    private static final int POLL_TIME = 10000;
    private String platId;
    private String a;

    public PollModeTask() {
        this.setName("Poll-Mode-Info-Task");
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                this.FetchMode(this.platId);
                this.FetchLockMode();
                Thread.sleep(10000L);
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch an exception [" + ex.getMessage() + "]", 2));
            }
        }
    }

    private void FetchMode(String platId) {
        try {
            ICommand command = CommandCreator.getInstance().createCommand("FetchModeCmd", "");
            Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
            if (!ret.booleanValue()) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[pollModeInfoTask: Mode info  failed is table tt_lpn_slot exist or not empty]: ", 2));
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[pollModeInfoTask: Mode info  error]: " + ex, 2));
        }
    }

    private void FetchLockMode() {
        try {
            for (int i = 1; i < SlotManager.getInstance().getSlotInfoCount(); ++i) {
                SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(String.valueOf(i));
                SlotManager.getInstance().initSlotStatus(slotInfo);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[pollModeInfoTask: LockMode info  error]: " + ex, 2));
        }
    }
}

