/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components.task;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.data.OrderInfo;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class OrderDataResotreMysqlTask
extends Thread {
    private static final Logger logger = Logger.getLogger(OrderDataResotreMysqlTask.class);
    private final BlockingQueue<List<OrderInfo>> orderBillListQueue = new LinkedBlockingQueue<List<OrderInfo>>();
    private static final int REQUEST_INTERVAL = 10000;

    public OrderDataResotreMysqlTask() {
        this.setName("Order-Bill-Data-Resotre-Mysql-Task");
    }

    public void offerOrderListToQueue(List<OrderInfo> listOrderBills) {
        if (listOrderBills == null) {
            return;
        }
        this.orderBillListQueue.offer(listOrderBills);
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(10000L);
                this.updateOrderInfoList();
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch an exception [" + ex.getMessage() + "]", 2));
            }
        }
    }

    protected void updateOrderInfoList() throws InterruptedException {
        List<OrderInfo> listOrderBills = this.orderBillListQueue.take();
        if (listOrderBills.size() > 0) {
            ICommand command = CommandCreator.getInstance().createCommand("AddOrderInfo", listOrderBills);
            Boolean res = SQLCommandExecutor.getInstance().executeCmd(command);
            if (res.booleanValue()) {
                ICommand c = CommandCreator.getInstance().createCommand("AddHistoryOrderInfo", listOrderBills);
                SQLCommandExecutor.getInstance().executeCmd(c);
            } else {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "insert orderbill failed", 2));
            }
        }
    }
}

