/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components.task;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.OrderManager;
import com.simba.server.components.SlotManager;
import com.simba.server.components.data.LpnInfo;
import com.simba.server.components.data.SlotInfo;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;

public class LpnStatusCheckTask
extends Thread {
    private static final Logger logger = Logger.getLogger(LpnStatusCheckTask.class);
    private static final int REQUEST_INTERVAL = 15000;

    public LpnStatusCheckTask() {
        this.setName("Lpn-Expire-Time-Task");
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                this.doHandleExpireOrderMap();
                this.doHandleLpnStatusTask();
                Thread.sleep(15000L);
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch an exception [" + ex.getMessage() + "]", 2));
            }
        }
    }

    private void doHandleExpireOrderMap() {
        try {
            ArrayList<String> keyList = new ArrayList<String>();
            for (Map.Entry<String, Timestamp> entry : OrderManager.getInstance().getTaskLpnSkuMap().entrySet()) {
                long putTicks;
                String key = entry.getKey();
                Timestamp ts = entry.getValue();
                Date dnow = new Date();
                long nowTicks = dnow.getTime();
                long timeSpan = (nowTicks - (putTicks = ts.getTime())) / 1000L;
                if (timeSpan <= 43200L) continue;
                keyList.add(key);
            }
            for (int i = 0; i < keyList.size(); ++i) {
                String curKey = (String)keyList.get(i);
                if (!OrderManager.getInstance().getTaskLpnSkuMap().containsKey(curKey)) continue;
                OrderManager.getInstance().getTaskLpnSkuMap().remove(curKey);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "doHandleExpireOrderMap Catch an exception [" + ex.getMessage() + "]", 2));
        }
    }

    private void doHandleLpnStatusTask() {
        try {
            LinkedList lpnLists = new LinkedList();
            ICommand command = CommandCreator.getInstance().createCommand("FetchLpnExpireInfo", lpnLists);
            Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
            if (lpnLists.size() > 0) {
                for (LpnInfo lpnInfo : lpnLists) {
                    this.handleSlotLight(lpnInfo);
                }
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "doHandleLpnStatusTask Catch an exception [" + ex.getMessage() + "]", 2));
        }
    }

    private void handleSlotLight(LpnInfo lpnInfo) {
        try {
            int slot = lpnInfo.getSlot();
            String slotId = String.valueOf(slot);
            SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(slotId);
            if (slotInfo == null) {
                return;
            }
            slotInfo.setLpnStatus(2);
            OrderManager.getInstance().senSlotLightoPlc(slotInfo);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handleSlotLight Catch an exception [" + ex.getMessage() + "]", 2));
        }
    }
}

