/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components.task;

import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.FtpUtils;
import com.simba.server.controllers.data.SlotManager;
import com.simba.server.controllers.luolai.LuolaiCommonParams;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.log4j.Logger;

public class DeleteExpiredData
extends Thread {
    private static final Logger logger = Logger.getLogger(DeleteExpiredData.class);
    private static final int REQUEST_INTERVAL = 1200000;
    private static final int spareTime = 1200000;
    private int ExpireDay;

    public DeleteExpiredData() {
        this.setName("Delete-Expired-Data-Task");
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(1200000L);
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch an exception [" + ex.getMessage() + "]", 2));
            }
        }
    }

    private void doHandleDeleteTask() {
        try {
            long currentTime = new Date().getTime();
            if (LuolaiCommonParams.getInstance().getServerFtpUrl().isEmpty()) {
                return;
            }
            if (currentTime - SlotManager.getInstance().LastPacketOffTime < 1200000L) {
                return;
            }
            FtpUtils ftpUtils = new FtpUtils();
            this.ExpireDay = Integer.parseInt(LuolaiCommonParams.getInstance().getPictureExpire());
            Long NowTimeLong = new Date().getTime();
            Long DeadLine = NowTimeLong - (long)(this.ExpireDay * 24 * 60 * 60) * 1000L;
            String deadTime = new SimpleDateFormat("yyyy-MM-dd-HH").format(new Date(DeadLine));
            String[] tempTimeStr = deadTime.split("-");
            String tempYear = tempTimeStr[0];
            String tempMonth = tempTimeStr[1];
            String tempDay = tempTimeStr[2];
            String tempHour = tempTimeStr[3];
            FTPFile[] files = null;
            this.DoDeleteFiles(ftpUtils, files, tempYear, tempMonth);
            this.DoDeleteFiles(ftpUtils, files, tempYear + "/" + Integer.parseInt(tempMonth), tempDay);
            this.DoDeleteFiles(ftpUtils, files, tempYear + "/" + Integer.parseInt(tempMonth) + "/" + Integer.parseInt(tempDay), tempHour);
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Delete completed! Time cost is: " + (new Date().getTime() - NowTimeLong), 3));
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Delete Expired Date.doHandlerDeleteTask: Catch an exception [" + ex.getMessage() + "]", 2));
        }
    }

    private void DoDeleteFiles(FtpUtils ftpUtils, FTPFile[] files, String listFiles, String timeCompare) {
        try {
            ftpUtils.initFtpClient();
            files = ftpUtils.ftpClient.listFiles(listFiles);
            ftpUtils.ftpClient.disconnect();
            for (FTPFile file : files) {
                if (Integer.parseInt(file.getName()) >= Integer.parseInt(timeCompare)) continue;
                ftpUtils.RemoveDir(listFiles + "/" + file.getName());
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "DeleteExpiredDate.DoDeleteFiles:Catch an exception(DirName:" + listFiles + ") [" + ex.getMessage() + "]", 2));
        }
    }
}

