/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components.task;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.OrderManager;
import com.simba.server.components.data.DeleteData;
import java.sql.Timestamp;
import java.util.List;
import org.apache.log4j.Logger;

public class DelStaleDataTask
extends Thread {
    private static final Logger logger = Logger.getLogger(DelStaleDataTask.class);
    private static final int REQUEST_INTERVAL = 30000;
    private static final int DEL_INTERVAL_TIME = 50000;

    public DelStaleDataTask() {
        this.setName("Del-Stale-Data-Task");
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                this.deleteOverTimeSortData();
                Thread.sleep(30000L);
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LogUtil.LogError(logger, "Catch an exception [" + ex.getMessage() + "]");
            }
        }
    }

    private void deleteOverTimeSortData() {
        try {
            Timestamp nowTime = OrderManager.getInstance().getTimestamp();
            if (nowTime == null) {
                return;
            }
            long time = nowTime.getTime();
            long IntervalTime = System.currentTimeMillis() - time;
            if (IntervalTime == 50000L) {
                this.doClear();
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[deleteOverTimeSortData] : Catch an exception [" + ex.getMessage() + "]");
        }
    }

    private void doClear() {
        List<DeleteData> delDataList = OrderManager.getInstance().getDelDataList();
        for (DeleteData deleteData : delDataList) {
            int delDays = deleteData.getDelDays();
            long delDaysTime = delDays * 24 * 3600 * 1000;
            Timestamp deleteTime = new Timestamp(System.currentTimeMillis() - delDaysTime);
            deleteData.setDeleteBeforeTime(deleteTime);
            ICommand commandDelPacketOff = CommandCreator.getInstance().createCommand("DelStaleDataCmd", deleteData);
            SQLCommandExecutor.getInstance().executeCmd(commandDelPacketOff);
            if (deleteData.getDelCount() <= 0) continue;
            LogUtil.LogDebug(logger, "Delete " + deleteData.getDelName() + " Data Count : [" + deleteData.getDelCount() + "]");
        }
    }
}

