/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components.task;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.UploadInfo;
import com.simba.server.netclient.DefaultClientManager;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class DataUploadTask
extends Thread {
    private static final Logger logger = Logger.getLogger(DataUploadTask.class);
    private static final int REQUEST_INTERVAL = 10000;

    public DataUploadTask() {
        this.setName("Data-Upload-Task");
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                this.doHandleUploadOrderFinishTask();
                this.doHandleUploadDwsTask();
                Thread.sleep(10000L);
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch an exception [" + ex.getMessage() + "]", 2));
            }
        }
    }

    private void doHandleUploadDwsTask() {
        try {
            LinkedList uploadList = new LinkedList();
            ICommand command = CommandCreator.getInstance().createCommand("FetchDwsUploadInfoCmd", uploadList);
            SQLCommandExecutor.getInstance().executeCmd(command);
            if (uploadList.size() > 0) {
                for (UploadInfo uploadInfo : uploadList) {
                    this.handleUploadDws(uploadInfo);
                }
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "doHandleUploadDwsTask Catch an exception [" + ex.getMessage() + "]", 2));
        }
    }

    private void handleUploadDws(UploadInfo uploadInfo) {
        boolean res = false;
        String msg = this.createMsgSentToWms(uploadInfo);
        res = DefaultClientManager.getInstance().sendUploadMsgToStoClient(msg.getBytes());
        if (res) {
            ICommand command = CommandCreator.getInstance().createCommand("UpdateDwsUpLoadFlagCmd", uploadInfo);
            SQLCommandExecutor.getInstance().executeCmd(command);
        } else {
            ICommand command = CommandCreator.getInstance().createCommand("UpdateUpLoadNumCmd", uploadInfo);
            SQLCommandExecutor.getInstance().executeCmd(command);
        }
    }

    public String createMsgSentToWms(UploadInfo uploadInfo) {
        String serviceName = "DwsFinish";
        JSONObject sendObj = new JSONObject();
        try {
            String uuid = SlotManager.getInstance().createUUID();
            String wayBill = uploadInfo.getWayBill();
            int wayDirection = uploadInfo.getWayDirection();
            double orderWeight = uploadInfo.getOrderWeight();
            double actWeight = uploadInfo.getActWeight();
            int HeaderID = 34;
            sendObj.put("HeaderID", HeaderID);
            sendObj.put("ServiceName", serviceName);
            sendObj.put("Uuid", uuid);
            sendObj.put("wayBill", wayBill);
            sendObj.put("wayDirection", wayDirection);
            sendObj.put("orderWeight", orderWeight);
            sendObj.put("actWeight", actWeight);
            sendObj.put("opTime", SorterProtocolCreator.getInstance().createCurrentTimeStamp());
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[DataUploadTask.createSentToWmsMsg] createSentToWmsMsg Error -- Exception : " + ex, 2));
        }
        return sendObj.toString() + "#";
    }

    private void doHandleUploadOrderFinishTask() {
        try {
            UploadInfo uploadInfo = new UploadInfo();
            ICommand command = CommandCreator.getInstance().createCommand("FetchUploadInfo", uploadInfo);
            Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
            if (ret.booleanValue() && this.uploadOrderFinishMsg(uploadInfo)) {
                this.updateUploadStatus(uploadInfo);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "DataUploadTask Catch an exception [" + ex.getMessage() + "]", 2));
        }
    }

    private boolean uploadOrderFinishMsg(UploadInfo uploadInfo) {
        boolean res = false;
        String strOrderFinishContents = uploadInfo.getContent();
        byte[] content = strOrderFinishContents.getBytes();
        res = DefaultClientManager.getInstance().sendUploadMsgToStoClient(content);
        return res;
    }

    private void updateUploadStatus(UploadInfo uploadInfo) {
        ICommand command = CommandCreator.getInstance().createCommand("UpdateUploadStatus", uploadInfo);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }
}

