/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.common.utils.FrameUtils;
import com.simba.server.components.CommonDefines;
import com.simba.server.components.SlotManager;
import com.simba.server.components.data.OrderInfo;
import com.simba.server.components.data.PlcInfo;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.components.data.SortInfo;
import com.simba.server.components.data.UploadReturnSkuInfo;
import com.simba.server.controllers.luolai.LuolaiCommonParams;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class SorterProtocolCreator {
    private static final Logger logger = Logger.getLogger(SorterProtocolCreator.class);
    private static final byte PLAT_MODE_SCANNED = 3;
    private static final int RESET_PLAT_RRESULT_BUFFER_SIZE = 15;
    private static final int SORT_INFO_CARID_CONSTANT_BUFFER_SIZE = 21;
    private static final int SORT_INFO_PLAT_CONSTANT_BUFFER_SIZE = 26;
    private static final int SLOT_OPEN_CONSTANT_SIZE = 15;
    private static final int HEART_BEAT_HEADER_ID = 10;
    private static final int WMS_ORDER_FINISH_HEADER_ID = 31;
    private static final int SLOT_LIGHT_BUFFER_SIZE = 20;

    public static SorterProtocolCreator getInstance() {
        return SorterProtocolCreatorHolder.INSTANCE;
    }

    private SorterProtocolCreator() {
    }

    public Timestamp createCurrentTimeStamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public byte[] createResetPlatBuffer(int platId) {
        byte[] replyBuffer = new byte[15];
        int position = 0;
        byte[] header = CommonDefines.REPLY_HEADER;
        System.arraycopy(header, 0, replyBuffer, position, header.length);
        byte[] command = new byte[]{14};
        System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
        byte[] platformId = new byte[]{(byte)platId};
        System.arraycopy(platformId, 0, replyBuffer, position += command.length, platformId.length);
        byte[] timeStampBuffer = this.createSystemTimeToBuffer();
        System.arraycopy(timeStampBuffer, 0, replyBuffer, position += platformId.length, timeStampBuffer.length);
        byte[] finalByte = new byte[]{1};
        System.arraycopy(finalByte, 0, replyBuffer, position += timeStampBuffer.length, finalByte.length);
        byte[] replayEnder = CommonDefines.REPLY_ENDER;
        System.arraycopy(replayEnder, 0, replyBuffer, position += finalByte.length, replayEnder.length);
        position += replayEnder.length;
        return replyBuffer;
    }

    public byte[] createSortInfoWithCarID(SortInfo sortInfo) {
        int slotsNum = sortInfo.getSlotsList().size();
        String plcId = sortInfo.getPlcId();
        int bufferLen = 21 + 2 * slotsNum + plcId.length();
        byte[] replyBuffer = new byte[bufferLen];
        try {
            int position = 0;
            byte[] header = CommonDefines.REPLY_HEADER;
            System.arraycopy(header, 0, replyBuffer, position, header.length);
            byte[] command = new byte[]{7};
            System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
            int carId = Integer.parseInt(sortInfo.getCarId());
            byte[] carIdBuf = new byte[2];
            FrameUtils.getInstance().setShortBigEndian(0, carId, carIdBuf);
            System.arraycopy(carIdBuf, 0, replyBuffer, position += command.length, carIdBuf.length);
            byte[] spliteBuffer = new byte[]{-18, -18};
            System.arraycopy(spliteBuffer, 0, replyBuffer, position += carIdBuf.length, spliteBuffer.length);
            position += spliteBuffer.length;
            if (slotsNum == 0) {
                byte[] slots = new byte[]{1, 0, 0};
                System.arraycopy(slots, 0, replyBuffer, position, slots.length);
                position += slots.length;
            } else {
                byte[] slotsNumBuf = new byte[]{(byte)slotsNum};
                System.arraycopy(slotsNumBuf, 0, replyBuffer, position, slotsNumBuf.length);
                position += slotsNumBuf.length;
                for (int slot : sortInfo.getSlotsList()) {
                    byte[] slotBuf = new byte[2];
                    FrameUtils.getInstance().setShortBigEndian(0, slot, slotBuf);
                    System.arraycopy(slotBuf, 0, replyBuffer, position, slotBuf.length);
                    position += slotBuf.length;
                }
            }
            byte[] slotUnusual = new byte[]{0};
            System.arraycopy(slotUnusual, 0, replyBuffer, position, slotUnusual.length);
            byte[] plcidLen = new byte[]{(byte)plcId.length()};
            System.arraycopy(plcidLen, 0, replyBuffer, position += slotUnusual.length, plcidLen.length);
            byte[] plcid = plcId.getBytes();
            System.arraycopy(plcid, 0, replyBuffer, position += plcidLen.length, plcid.length);
            byte[] timeStampBuffer = this.createSystemTimeToBuffer();
            System.arraycopy(timeStampBuffer, 0, replyBuffer, position += plcid.length, timeStampBuffer.length);
            byte[] finalByte = new byte[]{1};
            System.arraycopy(finalByte, 0, replyBuffer, position += timeStampBuffer.length, finalByte.length);
            byte[] replayEnder = CommonDefines.REPLY_ENDER;
            System.arraycopy(replayEnder, 0, replyBuffer, position += finalByte.length, replayEnder.length);
            position += replayEnder.length;
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[SortCommandManager.createSortInfoBuffer] Create Sort Info Buffer Error -- Exception : " + ex, 2));
            replyBuffer = null;
        }
        return replyBuffer;
    }

    public byte[] createSortInfoWithPlat(SortInfo sortInfo) {
        String barcode = sortInfo.getBarcode();
        if (barcode == null) {
            barcode = "NoneCode";
        }
        int slotsNum = sortInfo.getSlotsList().size();
        int barcodeLen = barcode.length();
        int bufferLen = 26 + barcodeLen + 2 * slotsNum + 1;
        byte[] replyBuffer = new byte[bufferLen];
        try {
            int position = 0;
            byte[] header = CommonDefines.REPLY_HEADER;
            System.arraycopy(header, 0, replyBuffer, position, header.length);
            byte[] command = new byte[]{4};
            System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
            position += command.length;
            int iPlatid = Integer.parseInt(sortInfo.getPlatId());
            PlcInfo plcInfo = SlotManager.getInstance().getPlcInfoByPlatID(iPlatid);
            if (plcInfo != null) {
                iPlatid -= plcInfo.getAdjustPlatNumber();
            } else {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[SortCommandManager.createSortInfoWithPlat] Create Sort Info Buffer Error -- plcInfo==null : ", 2));
            }
            byte[] platId = new byte[]{(byte)iPlatid};
            System.arraycopy(platId, 0, replyBuffer, position, platId.length);
            int packageSeriaNo = Integer.parseInt(sortInfo.getPacketSerialNo());
            byte[] packageSeria = new byte[]{(byte)packageSeriaNo};
            System.arraycopy(packageSeria, 0, replyBuffer, position += platId.length, packageSeria.length);
            byte[] platMode = new byte[]{3};
            System.arraycopy(platMode, 0, replyBuffer, position += packageSeria.length, platMode.length);
            byte[] barcodeLenBuf = new byte[]{(byte)barcodeLen};
            System.arraycopy(barcodeLenBuf, 0, replyBuffer, position += platMode.length, barcodeLenBuf.length);
            byte[] barcodeBuf = barcode.getBytes();
            System.arraycopy(barcodeBuf, 0, replyBuffer, position += barcodeLenBuf.length, barcodeBuf.length);
            byte[] splitCommandBuf = new byte[]{7};
            System.arraycopy(splitCommandBuf, 0, replyBuffer, position += barcodeBuf.length, splitCommandBuf.length);
            position += splitCommandBuf.length;
            if (slotsNum == 0) {
                byte[] slots = new byte[]{1, 0, 0};
                System.arraycopy(slots, 0, replyBuffer, position, slots.length);
                position += slots.length;
            } else {
                byte[] slotsNumBuf = new byte[]{(byte)slotsNum};
                System.arraycopy(slotsNumBuf, 0, replyBuffer, position, slotsNumBuf.length);
                position += slotsNumBuf.length;
                for (int slot : sortInfo.getSlotsList()) {
                    byte[] slotBuf = new byte[2];
                    int plcSlot = slot;
                    FrameUtils.getInstance().setShortBigEndian(0, plcSlot, slotBuf);
                    System.arraycopy(slotBuf, 0, replyBuffer, position, slotBuf.length);
                    position += slotBuf.length;
                }
            }
            byte[] errorCode = new byte[]{-32};
            System.arraycopy(errorCode, 0, replyBuffer, position, errorCode.length);
            byte[] weightBuffer = new byte[]{-18, -18};
            System.arraycopy(weightBuffer, 0, replyBuffer, position += errorCode.length, weightBuffer.length);
            byte[] volumeBuffer = new byte[]{-17, -17, -17, -17};
            System.arraycopy(volumeBuffer, 0, replyBuffer, position += weightBuffer.length, volumeBuffer.length);
            byte[] scannedTimeBuffer = this.createSystemTimeToBuffer();
            System.arraycopy(scannedTimeBuffer, 0, replyBuffer, position += volumeBuffer.length, scannedTimeBuffer.length);
            byte[] finalByte = new byte[]{1};
            System.arraycopy(finalByte, 0, replyBuffer, position += scannedTimeBuffer.length, finalByte.length);
            byte[] replayEnder = CommonDefines.REPLY_ENDER;
            System.arraycopy(replayEnder, 0, replyBuffer, position += finalByte.length, replayEnder.length);
            position += replayEnder.length;
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[SortCommandManager.createSortInfoWithPlat] Create Sort Info Buffer Error -- Exception : " + ex, 2));
            replyBuffer = null;
        }
        return replyBuffer;
    }

    public byte[] createSystemTimeToBuffer() {
        String now = new SimpleDateFormat("ddHHmmss").format(new Date());
        byte[] timeBuffer = now.getBytes();
        return timeBuffer;
    }

    public String createDropMsg(SortInfo sortInfo) {
        JSONObject sendObj = new JSONObject();
        JSONObject requestObj = new JSONObject();
        try {
            String carId;
            String strWorkerNumber;
            requestObj.put("productId", LuolaiCommonParams.getInstance().getProductID());
            requestObj.put("deviceId", LuolaiCommonParams.getInstance().getDeviceID());
            requestObj.put("method", "event");
            requestObj.put("event", "packageInfo");
            requestObj.put("timestamp", sortInfo.getTimestampPacketOff().getTime());
            JSONArray paramList = new JSONArray();
            JSONObject param = new JSONObject();
            JSONArray chuteList = new JSONArray();
            int stoMode = 1;
            JSONObject dataObj = sortInfo.getDataObj();
            String stoStrMode = "none";
            String currentMode = LuolaiCommonParams.getInstance().getStoMode();
            if (currentMode.equals("departure")) {
                stoMode = 2;
            }
            if ((strWorkerNumber = dataObj.getString("workerNumber")) == null) {
                strWorkerNumber = "";
            }
            if ((carId = sortInfo.getCarId()) == null || carId.equals("")) {
                carId = "0";
            }
            if (carId.contains("-")) {
                carId = carId.substring(carId.indexOf("-") + 1);
            }
            double dweight = 0.0;
            if (sortInfo.getWeight() != null && sortInfo.getWeight().length() > 0) {
                dweight = Double.parseDouble(sortInfo.getWeight());
            }
            param.put("mode", stoMode);
            param.put("inductionNo", sortInfo.getPlcPlatID());
            param.put("trayNo", Integer.parseInt(carId));
            param.put("layerNo", sortInfo.getLayer());
            param.put("chuteNo", sortInfo.getDroppedSlotId());
            param.put("chuteCode", chuteList);
            param.put("bagCode", sortInfo.getPackCode());
            param.put("transportTaskNo", "");
            param.put("waybillNo", sortInfo.getBarcode());
            param.put("scanTime", sortInfo.getTimestampScanned().getTime());
            param.put("opTime", sortInfo.getTimestampPacketOff().getTime());
            param.put("logicChute", 0);
            param.put("landOnTrayTime", sortInfo.getTimestampPacketOn().getTime());
            param.put("empNo", strWorkerNumber);
            param.put("sourceCode", sortInfo.getSortSource());
            param.put("weight", dweight);
            param.put("plannedChuteNo", sortInfo.getSlotsList());
            int resultCode = sortInfo.getServerErrorCode();
            if (sortInfo.getRookieServerError() > 0) {
                resultCode = sortInfo.getRookieServerError();
            }
            param.put("resultCode", resultCode);
            double turnNumber = sortInfo.getTurnNumber() / 2;
            String result = String.format("%.1f", turnNumber);
            turnNumber = Double.parseDouble(result);
            param.put("cycleNum", turnNumber);
            paramList.put(param);
            requestObj.put("paramsList", paramList);
            sendObj.put("ServiceName", "PackOff");
            sendObj.put("content", requestObj);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[SortCommandManager.createDropMsg] createDropMsg Error -- Exception : " + ex, 2));
        }
        return sendObj.toString();
    }

    public String createPackageMsg(String packageCode, int chuteNo) {
        JSONObject sendObj = new JSONObject();
        JSONObject requestObj = new JSONObject();
        try {
            requestObj.put("productId", LuolaiCommonParams.getInstance().getProductID());
            requestObj.put("deviceId", LuolaiCommonParams.getInstance().getDeviceID());
            requestObj.put("method", "event");
            requestObj.put("event", "chuteBag");
            requestObj.put("timestamp", SorterProtocolCreator.getInstance().createCurrentTimeStamp().getTime());
            JSONObject param = new JSONObject();
            JSONArray paramsList = new JSONArray();
            String strWorkerNumber = "";
            param.put("chuteNo", chuteNo);
            param.put("bagCode", packageCode);
            param.put("empNo", strWorkerNumber);
            param.put("opTime", SorterProtocolCreator.getInstance().createCurrentTimeStamp().getTime() - 1L);
            paramsList.put(param);
            requestObj.put("paramsList", paramsList);
            sendObj.put("ServiceName", "Package");
            sendObj.put("content", requestObj);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[SortCommandManager.createDropMsg] createDropMsg Error -- Exception : " + ex, 2));
        }
        return sendObj.toString();
    }

    public String createScanMsg(SortInfo sortInfo) {
        JSONObject sendObj = new JSONObject();
        JSONObject requestObj = new JSONObject();
        try {
            requestObj.put("productId", LuolaiCommonParams.getInstance().getProductID());
            requestObj.put("deviceId", LuolaiCommonParams.getInstance().getDeviceID());
            requestObj.put("method", "event");
            requestObj.put("event", "scanInfo");
            requestObj.put("timestamp", SorterProtocolCreator.getInstance().createCurrentTimeStamp().getTime());
            JSONObject param = new JSONObject();
            JSONArray paramsList = new JSONArray();
            JSONObject dataObj = sortInfo.getDataObj();
            String strWorkerNumber = dataObj.getString("workerNumber");
            if (strWorkerNumber == null) {
                strWorkerNumber = "";
            }
            double dweight = 0.0;
            if (sortInfo.getWeight() != null && sortInfo.getWeight().length() > 0) {
                dweight = Double.parseDouble(sortInfo.getWeight());
            }
            param.put("inductionNo", sortInfo.getPlcPlatID());
            param.put("layerNo", sortInfo.getLayer());
            param.put("waybillNo", sortInfo.getBarcode());
            param.put("empNo", strWorkerNumber);
            param.put("scanTime", sortInfo.getTimestampScanned().getTime());
            param.put("weight", dweight);
            paramsList.put(param);
            requestObj.put("paramsList", paramsList);
            sendObj.put("ServiceName", "PlatScan");
            sendObj.put("content", requestObj);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[SortCommandManager.createDropMsg] createDropMsg Error -- Exception : " + ex, 2));
        }
        return sendObj.toString();
    }

    public String createReturnSkuMsg(UploadReturnSkuInfo uploadReturnSkuInfo) {
        JSONObject sendObj = new JSONObject();
        try {
            sendObj.put("HeaderID", 32);
            sendObj.put("Uuid", SlotManager.getInstance().createUUID());
            sendObj.put("ServiceName", "RejectSlotPackage");
            sendObj.put("Slot", uploadReturnSkuInfo.getSlotId());
            JSONArray Skus = new JSONArray();
            Map<String, UploadReturnSkuInfo> returnSkuMap = uploadReturnSkuInfo.getUploadReturnSkuMap();
            for (Map.Entry<String, UploadReturnSkuInfo> entry : returnSkuMap.entrySet()) {
                JSONObject skuObj = new JSONObject();
                UploadReturnSkuInfo skuInfo = entry.getValue();
                skuObj.put("Sku", skuInfo.getSkuBarcode());
                skuObj.put("Number", skuInfo.getSkuNum());
                skuObj.put("ItemName", skuInfo.getItemName());
                skuObj.put("BatchNumber", uploadReturnSkuInfo.getBatchCode());
                Skus.put(skuObj);
            }
            sendObj.put("Skus", Skus);
            sendObj.put("opTime", SorterProtocolCreator.getInstance().createCurrentTimeStamp());
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[SortCommandManager.createDropMsg] createDropMsg Error -- Exception : " + ex, 2));
        }
        return sendObj.toString() + "#";
    }

    public String createSlotStatusMsg(int lockStatus, SlotInfo slot) {
        JSONObject sendObj = new JSONObject();
        JSONObject requestObj = new JSONObject();
        try {
            requestObj.put("productId", LuolaiCommonParams.getInstance().getProductID());
            requestObj.put("deviceId", LuolaiCommonParams.getInstance().getDeviceID());
            requestObj.put("method", "event");
            requestObj.put("event", "chuteStatus");
            requestObj.put("timestamp", SorterProtocolCreator.getInstance().createCurrentTimeStamp().getTime());
            JSONObject param = new JSONObject();
            JSONArray paramsList = new JSONArray();
            param.put("chuteNo", Integer.parseInt(slot.getSlotId()));
            param.put("status", lockStatus);
            String packageCode = slot.getPackCode();
            if (packageCode.equalsIgnoreCase("unbind") || packageCode.equalsIgnoreCase("none")) {
                packageCode = "";
            }
            param.put("bagCode", slot.getPackCode());
            param.put("opTime", SorterProtocolCreator.getInstance().createCurrentTimeStamp().getTime());
            param.put("mailCount", slot.getMailCount());
            param.put("totalWeight", slot.getTotalWeight());
            param.put("opId", slot.getOpID());
            paramsList.put(param);
            requestObj.put("paramsList", paramsList);
            sendObj.put("ServiceName", "SlotStatus");
            sendObj.put("content", requestObj);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[SortCommandManager.createSlotLockUnLockMsg] createSlotLockUnLockMsg Error -- Exception : " + ex, 2));
        }
        return sendObj.toString();
    }

    public String createLoginMsg(int platID, String loginName) {
        JSONObject sendObj = new JSONObject();
        try {
            sendObj.put("ServiceName", "Login");
            sendObj.put("platID", platID);
            sendObj.put("userName", loginName);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[SortCommandManager.createLoginMsg] createLoginMsg Error -- Exception : " + ex, 2));
        }
        return sendObj.toString();
    }

    private int getStoDropErrorCode(int serverErrorCode) {
        int res = serverErrorCode;
        if (serverErrorCode == 5) {
            res = 3;
        }
        return res;
    }

    public void init() {
    }

    public void shutdown() {
    }

    public String createResponseMsg(int headerID, String serviceName, String uuid) {
        JSONObject requestObj = new JSONObject();
        try {
            requestObj.put("HeaderID", headerID);
            requestObj.put("ServiceName ", serviceName);
            requestObj.put("UUiD", uuid);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[SortCommandManager.createResponseMsg] createResponseMsg Error -- Exception : " + ex, 2));
        }
        return requestObj.toString();
    }

    public byte[] createSlotOPen(int slotId) {
        int bufferLen = 15;
        byte[] replyBuffer = new byte[bufferLen];
        int position = 0;
        byte[] header = CommonDefines.REPLY_HEADER;
        System.arraycopy(header, 0, replyBuffer, position, header.length);
        byte[] command = new byte[]{19};
        System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
        byte[] slotIdBuf = new byte[2];
        FrameUtils.getInstance().setShortBigEndian(0, slotId, slotIdBuf);
        System.arraycopy(slotIdBuf, 0, replyBuffer, position += command.length, slotIdBuf.length);
        boolean slotUnlock = false;
        byte[] slotLockStatus = new byte[]{(byte)(slotUnlock ? 1 : 0)};
        System.arraycopy(slotLockStatus, 0, replyBuffer, position += slotIdBuf.length, slotLockStatus.length);
        byte[] timeStampBuffer = this.createSystemTimeToBuffer();
        System.arraycopy(timeStampBuffer, 0, replyBuffer, position += slotLockStatus.length, timeStampBuffer.length);
        byte[] finalByte = new byte[]{1};
        System.arraycopy(finalByte, 0, replyBuffer, position += timeStampBuffer.length, finalByte.length);
        byte[] replayEnder = CommonDefines.REPLY_ENDER;
        System.arraycopy(replayEnder, 0, replyBuffer, position += finalByte.length, replayEnder.length);
        position += replayEnder.length;
        return replyBuffer;
    }

    public String createHeartBeatMsg() {
        String serviceName = "HeartBeat";
        JSONObject sendObj = new JSONObject();
        try {
            sendObj.put("HeaderID", 10);
            sendObj.put("ServiceName", serviceName);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[SortCommandManager.createHeartBeatMsg] createHeartBeatMsg Error -- Exception : " + ex, 2));
        }
        return sendObj.toString() + "#";
    }

    public String createOrderFinishMsg(SlotInfo slotInfo) {
        String serviceName = "SlotPackage";
        JSONObject sendObj = new JSONObject();
        try {
            String uuid = SlotManager.getInstance().createUUID();
            String lpn = slotInfo.getLpn();
            int lpnQty = slotInfo.getLpnQty();
            int actLpnQty = slotInfo.getMailCount();
            int slotID = Integer.parseInt(slotInfo.getSlotId());
            JSONArray skuArray = new JSONArray();
            Map<String, OrderInfo> mapSku = slotInfo.getSkuMap();
            for (Map.Entry<String, OrderInfo> entry : mapSku.entrySet()) {
                JSONObject skuObj = new JSONObject();
                OrderInfo order = entry.getValue();
                skuObj.put("sku", order.getSkuBarcode());
                skuObj.put("ActSkuQty", order.getPackOffQty());
                int lostSkuQty = order.getSkuQty() - order.getPackOffQty();
                if (lostSkuQty < 0) {
                    LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[SortCommandManager.createOrderFinishMsg] createOrderFinishMsg Error  sku:" + order.getSkuBarcode() + " lostQty=" + lostSkuQty, 2));
                }
                skuObj.put("LostSkuQty", order.getSkuQty() - order.getPackOffQty());
                skuArray.put(skuObj);
            }
            sendObj.put("HeaderID", 31);
            sendObj.put("ServiceName", serviceName);
            sendObj.put("Uuid", uuid);
            sendObj.put("Lpn", lpn);
            sendObj.put("LpnQty", lpnQty);
            sendObj.put("ActLpnQty", actLpnQty);
            int lostLpnQty = lpnQty - actLpnQty;
            if (lostLpnQty < 0) {
                lostLpnQty = 0;
            }
            sendObj.put("LostLpnQty", lostLpnQty);
            sendObj.put("Slot", slotID);
            sendObj.put("Skus", skuArray);
            sendObj.put("opTime", SorterProtocolCreator.getInstance().createCurrentTimeStamp());
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[SortCommandManager.createOrderFinishMsg] createOrderFinishMsg Error -- Exception : " + ex, 2));
        }
        return sendObj.toString() + "#";
    }

    public byte[] createSlotLightBuffer(SlotInfo slotInfo) {
        int slotID = Integer.parseInt(slotInfo.getSlotId());
        boolean greenLightStatus = false;
        boolean yellowLightStatus = false;
        int redLightStatus = 0;
        if (slotInfo.getIsLocked() == 0 && slotInfo.getIsShadow() == 0) {
            if (slotInfo.getLpnStatus() == 1) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "send " + slotID + " light green", 1));
                greenLightStatus = true;
                slotInfo.setPriorLightColor("G");
                slotInfo.setPriorShadow(false);
            } else if (slotInfo.getLpnStatus() == 2) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "send " + slotID + " light yellow", 1));
                yellowLightStatus = true;
                slotInfo.setPriorLightColor("Y");
                slotInfo.setPriorShadow(false);
            } else if (slotInfo.getLpnTaskInProcess() > 0) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "send " + slotID + " light red stable", 1));
                redLightStatus = 1;
                slotInfo.setPriorLightColor("R");
                slotInfo.setPriorShadow(false);
            }
        } else if (slotInfo.getIsLocked() == 1 && slotInfo.getIsShadow() == 0) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "send " + slotID + " light red RS", 1));
            redLightStatus = 2;
            slotInfo.setPriorLightColor("RS");
            slotInfo.setPriorShadow(false);
        } else if (slotInfo.getIsShadow() == 1) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "send " + slotID + " light red RS coz cur slot is shadow", 1));
            redLightStatus = 2;
            slotInfo.setPriorShadow(true);
        } else if (slotInfo.getIsShadow() == 0 && slotInfo.isPriorShadow()) {
            String priorColor = slotInfo.getPriorLightColor();
            if (priorColor.equalsIgnoreCase("G")) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "send " + slotID + " light Green coz of prior is G", 1));
                greenLightStatus = true;
                slotInfo.setPriorLightColor("G");
                slotInfo.setPriorShadow(false);
            } else if (priorColor.equalsIgnoreCase("Y")) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "send " + slotID + " light Yellow  coz of prior is Y", 1));
                yellowLightStatus = true;
                slotInfo.setPriorLightColor("Y");
                slotInfo.setPriorShadow(false);
            } else if (priorColor.equalsIgnoreCase("R")) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "send " + slotID + " light R  coz of prior is R", 1));
                redLightStatus = 1;
                slotInfo.setPriorLightColor("R");
                slotInfo.setPriorShadow(false);
            } else if (priorColor.equalsIgnoreCase("RS")) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "send " + slotID + " light RS  coz of prior is RS", 1));
                redLightStatus = 2;
                slotInfo.setPriorLightColor("RS");
                slotInfo.setPriorShadow(false);
            }
        }
        int slotStatus = slotInfo.getIsLocked();
        byte[] replyBuffer = new byte[20];
        int position = 0;
        byte[] header = CommonDefines.REPLY_HEADER;
        System.arraycopy(header, 0, replyBuffer, position, header.length);
        byte[] command = new byte[]{64};
        System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
        byte[] slotBuf = new byte[2];
        int plcSlot = slotID;
        FrameUtils.getInstance().setShortBigEndian(0, plcSlot, slotBuf);
        System.arraycopy(slotBuf, 0, replyBuffer, position += command.length, slotBuf.length);
        byte[] greenLight = new byte[]{(byte)(greenLightStatus ? 1 : 0)};
        System.arraycopy(greenLight, 0, replyBuffer, position += slotBuf.length, greenLight.length);
        byte[] redLight = new byte[]{(byte)redLightStatus};
        System.arraycopy(redLight, 0, replyBuffer, position += greenLight.length, redLight.length);
        byte[] yellowLight = new byte[]{(byte)(yellowLightStatus ? 1 : 0)};
        System.arraycopy(yellowLight, 0, replyBuffer, position += redLight.length, yellowLight.length);
        byte[] slotbyte = new byte[]{(byte)slotStatus};
        System.arraycopy(slotbyte, 0, replyBuffer, position += yellowLight.length, slotbyte.length);
        byte[] timeStampBuffer = this.createSystemTimeToBuffer();
        System.arraycopy(timeStampBuffer, 0, replyBuffer, position += slotbyte.length, timeStampBuffer.length);
        byte[] finalByte = new byte[]{1};
        System.arraycopy(finalByte, 0, replyBuffer, position += timeStampBuffer.length, finalByte.length);
        byte[] replayEnder = CommonDefines.REPLY_ENDER;
        System.arraycopy(replayEnder, 0, replyBuffer, position += finalByte.length, replayEnder.length);
        position += replayEnder.length;
        return replyBuffer;
    }

    private static class SorterProtocolCreatorHolder {
        private static final SorterProtocolCreator INSTANCE = new SorterProtocolCreator();

        private SorterProtocolCreatorHolder() {
        }
    }
}

