/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.PlatInstance;
import com.simba.server.components.PlatInstanceManager;
import com.simba.server.components.data.SortInfo;
import com.simba.server.controllers.luolai.LuolaiCommonParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class SortInfoManager {
    protected static final Logger logger = Logger.getLogger(SortInfoManager.class);
    private static int curAssignTask = 0;
    private final ConcurrentHashMap<String, SortInfo> sortInfoList = new ConcurrentHashMap();
    public final HashMap<String, Integer> mapNoInfoBarcodes = new HashMap();

    public static SortInfoManager getInstance() {
        return SortManagerHolder.INSTANCE;
    }

    private SortInfoManager() {
    }

    public void addSortInfo(SortInfo sortInfo) {
        if (sortInfo != null) {
            this.sortInfoList.put(sortInfo.getCarId(), sortInfo);
        }
    }

    public void clearSortInfoList() {
        this.sortInfoList.clear();
    }

    public boolean containsSortInfo(String key) {
        return this.sortInfoList.containsKey(key);
    }

    public SortInfo createSortInfo() {
        SortInfo sortInfo = new SortInfo();
        sortInfo.setSortingId(this.createSortingId());
        return sortInfo;
    }

    public SortInfo getSortInfo(String key) {
        return this.sortInfoList.get(key.toLowerCase());
    }

    public int getSortInfoCount() {
        return this.sortInfoList.size();
    }

    public SortInfo[] getSortInfoList() {
        return this.sortInfoList.values().toArray(new SortInfo[0]);
    }

    public void postInitProcess() {
    }

    public SortInfo removeSortInfo(String key) {
        return this.sortInfoList.remove(key);
    }

    private String createSortingId() {
        UUID uuid = UUID.randomUUID();
        long now = System.currentTimeMillis();
        String timeInfo = String.valueOf(now);
        String uuidStr = uuid.toString() + "-" + timeInfo;
        return uuidStr;
    }

    public void taskAssign(String barcode) {
        try {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "task assin barcode=" + barcode, 1));
            System.out.println("task assin barcode=" + barcode);
            ArrayList<Channel> channels = new ArrayList<Channel>();
            int provideNumber = LuolaiCommonParams.getInstance().getProvideNumber();
            for (int curPlat = provideNumber + 1; curPlat < provideNumber + 5; ++curPlat) {
                PlatInstance plat = PlatInstanceManager.getInstance().getPlatById(String.valueOf(curPlat));
                if (plat == null || plat.getPlatClient() == null || !plat.getPlatClient().isConnected()) continue;
                channels.add(plat.getPlatClient());
            }
            int nChannelCount = channels.size();
            if (nChannelCount == 0) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "video channel count 0", 2));
                curAssignTask = 0;
                return;
            }
            if (curAssignTask >= nChannelCount) {
                curAssignTask = 0;
            }
            Thread.sleep(1000L);
            this.sendTask(barcode, (Channel)channels.get(curAssignTask));
            ++curAssignTask;
        }
        catch (Exception EX) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "taskAssign error" + EX.getMessage(), 2));
        }
    }

    private void sendTask(String barCode, Channel channel) {
        byte[] content = this.createTaskContent(barCode);
        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "send task " + channel.getLocalAddress(), 1));
        JsonChannelManager.getInstance().commitResponse(channel, content, false);
    }

    public byte[] createTaskContent(String strBarCode) {
        JSONObject responObj = new JSONObject();
        responObj.put("ServiceName", "VideoCoding");
        responObj.put("barcode", strBarCode);
        responObj.put("platId", "1");
        return responObj.toString().getBytes();
    }

    public int getWaybillPriority(String strWaybillType) {
        int res = 0;
        if (strWaybillType == null || strWaybillType.equalsIgnoreCase("")) {
            return res;
        }
        switch (strWaybillType) {
            case "Interceptor": {
                res = 100;
                break;
            }
            case "Rookie": {
                res = 90;
                break;
            }
            case "PDD": {
                res = 90;
                break;
            }
            case "bigcustome": {
                res = 80;
                break;
            }
            case "ebigcustome": {
                res = 80;
                break;
            }
            case "callcenter": {
                res = 80;
                break;
            }
            case "taobaoonline": {
                res = 30;
                break;
            }
            case "taobaooffline": {
                res = 30;
                break;
            }
            default: {
                res = 30;
            }
        }
        return res;
    }

    private static class SortManagerHolder {
        private static final SortInfoManager INSTANCE = new SortInfoManager();

        private SortManagerHolder() {
        }
    }
}

