/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.data.MachineInfo;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.components.data.SortInfo;
import com.simba.server.controllers.IBarcodeQueryController;
import com.simba.server.controllers.IComplementController;
import com.simba.server.controllers.IMachineCloseController;
import com.simba.server.controllers.IMachineStartController;
import com.simba.server.controllers.IPacketOffController;
import com.simba.server.controllers.IPacketOnController;
import com.simba.server.controllers.IScannedController;
import com.simba.server.controllers.ISlotBindController;
import com.simba.server.controllers.ISlotCloseController;
import com.simba.server.controllers.ISlotFullController;
import com.simba.server.controllers.ISlotNormalController;
import com.simba.server.controllers.ISlotOpenController;
import com.simba.server.controllers.ISlotPackController;
import com.simba.server.controllers.ISlotUnlockController;
import com.simba.server.controllers.luolai.LuolaiComplementController;
import com.simba.server.controllers.luolai.LuolaiMachineCloseController;
import com.simba.server.controllers.luolai.LuolaiMachineStartController;
import com.simba.server.controllers.luolai.LuolaiPacketOffController;
import com.simba.server.controllers.luolai.LuolaiPacketOnController;
import com.simba.server.controllers.luolai.LuolaiScannedController;
import com.simba.server.controllers.luolai.LuolaiSlotCloseController;
import com.simba.server.controllers.luolai.LuolaiSlotFullController;
import com.simba.server.controllers.luolai.LuolaiSlotNormalController;
import com.simba.server.controllers.luolai.LuolaiSlotOpenController;
import com.simba.server.controllers.luolai.LuolaiSlotPackController;
import com.simba.server.controllers.luolai.LuolaiSlotUnlockController;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class SortControllerManager
implements IPacketOnController,
IPacketOffController,
IScannedController,
ISlotPackController,
ISlotUnlockController,
ISlotBindController,
IComplementController,
IMachineCloseController,
IMachineStartController,
IBarcodeQueryController,
ISlotFullController,
ISlotNormalController,
ISlotOpenController,
ISlotCloseController {
    private SortControllerManager sortControllerManager;
    public static final String SORT_INFO_MODE_BEST = "Best";
    public static final String SORT_INFO_MODE_STO = "STO";
    public static final String SORT_INFO_MODE_YUNDA = "Yunda";
    public static final String SORT_INFO_MODE_LUOLAI = "Luolai";
    private static final Logger logger = Logger.getLogger(SortControllerManager.class);
    private final HashMap<String, IComplementController> complementControllers = new HashMap();
    private volatile String currentSortInfoMode;
    private volatile String currentSortType;
    private final HashMap<String, IMachineCloseController> machineCloseControllers = new HashMap();
    private final HashMap<String, IMachineStartController> machineStartControllers = new HashMap();
    private final HashMap<String, IPacketOffController> packetOffControllers = new HashMap();
    private final HashMap<String, IPacketOnController> packetOnControllers = new HashMap();
    private final HashMap<String, IScannedController> scannedControllers = new HashMap();
    private final HashMap<String, ISlotBindController> slotBindControllers = new HashMap();
    private final HashMap<String, ISlotPackController> slotPackControllers = new HashMap();
    private final HashMap<String, ISlotUnlockController> slotUnlockControllers = new HashMap();
    private final HashMap<String, ISlotNormalController> slotNormalControllers = new HashMap();
    private final HashMap<String, ISlotFullController> slotFullControllers = new HashMap();
    private final HashMap<String, IBarcodeQueryController> barcodeQueryControllers = new HashMap();
    private final HashMap<String, ISlotOpenController> slotOpenControllers = new HashMap();
    private final HashMap<String, ISlotCloseController> slotClsoeControllers = new HashMap();

    public static SortControllerManager getInstance() {
        return SortBusinessManagerHolder.INSTANCE;
    }

    private SortControllerManager() {
    }

    public String getCurrentSortInfoMode() {
        return this.currentSortInfoMode;
    }

    public void init() {
        try {
            this.currentSortInfoMode = SORT_INFO_MODE_LUOLAI;
            this.initPacketOnControllers();
            this.initScannedControllers();
            this.initPacketOffControllers();
            this.initSlotPackControllers();
            this.initSlotUnlockControllers();
            this.initComplementControllers();
            this.initMachineStartControllers();
            this.initMachineCloseControllers();
            this.initSlotFullControllers();
            this.initSlotNormalControllers();
            this.initSlotOpenControllers();
            this.initSlotCloseControllers();
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Init Sort Business Manager Error -- Exception : " + ex, 2));
        }
    }

    @Override
    public void onComplementMessage(SortInfo sortInfo) {
        sortInfo.setSortInfoMode(this.currentSortInfoMode);
        IComplementController controller = this.complementControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onComplementMessage(sortInfo);
        }
        this.restoreComplementionInfo(sortInfo);
        this.sendComplementionToClient(sortInfo);
    }

    @Override
    public void onMachineCloseMessage(MachineInfo machineInfo) {
        IMachineCloseController controller = this.machineCloseControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onMachineCloseMessage(machineInfo);
        }
    }

    @Override
    public void onMachineStartMessage(MachineInfo machineInfo) {
        IMachineStartController controller = this.machineStartControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onMachineStartMessage(machineInfo);
        }
    }

    @Override
    public void onPacketOffMessage(SortInfo sortInfo) {
        sortInfo.setSortInfoMode(this.currentSortInfoMode);
        IPacketOffController controller = this.packetOffControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onPacketOffMessage(sortInfo);
        }
        this.restorePacketOffInfo(sortInfo);
        this.sendPacketOffToClient(sortInfo);
    }

    @Override
    public void onPacketOnMessage(SortInfo sortInfo) {
        sortInfo.setSortInfoMode(this.currentSortInfoMode);
        IPacketOnController controller = this.packetOnControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onPacketOnMessage(sortInfo);
        }
        this.restorePacketOnInfo(sortInfo);
        this.sendPacketOnToClient(sortInfo);
    }

    @Override
    public void onScannedMessage(SortInfo sortInfo) {
        IScannedController controller = this.scannedControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onScannedMessage(sortInfo);
        }
    }

    @Override
    public void onSlotBindMessage(SlotInfo slotInfo) {
        ISlotBindController controller = this.slotBindControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onSlotBindMessage(slotInfo);
        }
        this.restoreSlotBindInfo(slotInfo);
        this.sendSlotBindInfoToClient(slotInfo);
    }

    @Override
    public void onSlotPackMessage(SlotInfo slotInfo) {
        ISlotPackController controller = this.slotPackControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onSlotPackMessage(slotInfo);
        }
        this.restoreSlotPackInfo(slotInfo);
        this.sendSlotPackInfoToClient(slotInfo);
    }

    @Override
    public void onSlotUnlockMessage(SlotInfo slotInfo) {
        slotInfo.setSortInfoMode(this.currentSortInfoMode);
        ISlotUnlockController controller = this.slotUnlockControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onSlotUnlockMessage(slotInfo);
        }
        this.restoreSlotUnlockInfo(slotInfo);
        this.sendSlotUnlockInfoToClient(slotInfo);
    }

    public void setCurrentSortInfoMode(String currentSortInfoMode) {
        this.currentSortInfoMode = currentSortInfoMode;
    }

    public void shutdown() {
    }

    private void initComplementControllers() {
        LuolaiComplementController controller = new LuolaiComplementController();
        this.complementControllers.put(SORT_INFO_MODE_LUOLAI, controller);
    }

    private void initMachineCloseControllers() {
        LuolaiMachineCloseController controller = new LuolaiMachineCloseController();
        this.machineCloseControllers.put(SORT_INFO_MODE_LUOLAI, controller);
    }

    private void initMachineStartControllers() {
        LuolaiMachineStartController controller = new LuolaiMachineStartController();
        this.machineStartControllers.put(SORT_INFO_MODE_LUOLAI, controller);
    }

    private void initPacketOffControllers() {
        LuolaiPacketOffController controller = new LuolaiPacketOffController();
        this.packetOffControllers.put(SORT_INFO_MODE_LUOLAI, controller);
    }

    private void initPacketOnControllers() {
        LuolaiPacketOnController controller = new LuolaiPacketOnController();
        this.packetOnControllers.put(SORT_INFO_MODE_LUOLAI, controller);
    }

    private void initScannedControllers() {
        LuolaiScannedController controller = new LuolaiScannedController();
        this.scannedControllers.put(SORT_INFO_MODE_LUOLAI, controller);
    }

    private void initSlotPackControllers() {
        LuolaiSlotPackController controller = new LuolaiSlotPackController();
        this.slotPackControllers.put(SORT_INFO_MODE_LUOLAI, controller);
    }

    private void initSlotUnlockControllers() {
        LuolaiSlotUnlockController controller = new LuolaiSlotUnlockController();
        this.slotUnlockControllers.put(SORT_INFO_MODE_LUOLAI, controller);
    }

    private void initSlotFullControllers() {
        LuolaiSlotFullController controller = new LuolaiSlotFullController();
        this.slotFullControllers.put(SORT_INFO_MODE_LUOLAI, controller);
    }

    private void initSlotNormalControllers() {
        LuolaiSlotNormalController controller = new LuolaiSlotNormalController();
        this.slotNormalControllers.put(SORT_INFO_MODE_LUOLAI, controller);
    }

    private void initSlotOpenControllers() {
        LuolaiSlotOpenController controller = new LuolaiSlotOpenController();
        this.slotOpenControllers.put(SORT_INFO_MODE_LUOLAI, controller);
    }

    private void initSlotCloseControllers() {
        LuolaiSlotCloseController controller = new LuolaiSlotCloseController();
        this.slotClsoeControllers.put(SORT_INFO_MODE_LUOLAI, controller);
    }

    private void restoreComplementionInfo(SortInfo sortInfo) {
    }

    private void restorePacketOffInfo(SortInfo sortInfo) {
    }

    private void restorePacketOnInfo(SortInfo toDefineSortInfo) {
    }

    private void restoreScannedInfo(SortInfo sortInfo) {
    }

    private void restoreSlotBindInfo(SlotInfo slotInfo) {
    }

    private void restoreSlotPackInfo(SlotInfo slotInfo) {
    }

    private void restoreSlotUnlockInfo(SlotInfo slotInfo) {
    }

    private void sendComplementionToClient(SortInfo sortInfo) {
    }

    private void sendPacketOffToClient(SortInfo sortInfo) {
        sortInfo.sendPacketOffToClient();
    }

    private void sendPacketOnToClient(SortInfo sortInfo) {
    }

    private void sendScannedInfoToClient(SortInfo sortInfo) {
    }

    private void sendSlotBindInfoToClient(SlotInfo slotInfo) {
    }

    private void sendSlotPackInfoToClient(SlotInfo slotInfo) {
    }

    private void sendSlotUnlockInfoToClient(SlotInfo slotInfo) {
    }

    @Override
    public void onBarcodeQueryMessage(SortInfo sortInfo) {
        IBarcodeQueryController controller = this.barcodeQueryControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onBarcodeQueryMessage(sortInfo);
        }
    }

    @Override
    public void onSlotNormalMessage(SlotInfo slotInfo) {
        ISlotNormalController controller = this.slotNormalControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onSlotNormalMessage(slotInfo);
        }
    }

    @Override
    public void onSlotFullMessage(SlotInfo slotInfo) {
        ISlotFullController controller = this.slotFullControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onSlotFullMessage(slotInfo);
        }
    }

    @Override
    public void onSlotOpenMessage(SlotInfo slotInfo) {
        ISlotOpenController controller = this.slotOpenControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onSlotOpenMessage(slotInfo);
        }
    }

    @Override
    public void onSlotCloseMessage(SlotInfo slotInfo) {
        ISlotCloseController controller = this.slotClsoeControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onSlotCloseMessage(slotInfo);
        }
    }

    public String getCurrentSortType() {
        return this.currentSortType;
    }

    public void setCurrentSortType(String currentSortType) {
        this.currentSortType = currentSortType;
    }

    private static class SortBusinessManagerHolder {
        private static final SortControllerManager INSTANCE = new SortControllerManager();

        private SortBusinessManagerHolder() {
        }
    }
}

