/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.GlobalParam;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.ServerManager;
import com.simba.server.components.PlatInstance;
import java.io.File;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;

public class PlatInstanceManager {
    public static final int CODE_MODE_MANUAL = 1;
    public static final int CODE_MODE_SIMPLE = 0;
    private static final Logger logger = Logger.getLogger(PlatInstanceManager.class);
    private String configFile;
    private String configFilePath;
    private final ConcurrentHashMap<String, PlatInstance> plats = new ConcurrentHashMap();

    public static PlatInstanceManager getInstance() {
        return ProvidePlatManagerHolder.INSTANCE;
    }

    private PlatInstanceManager() {
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public String getConfigFilePath() {
        return this.configFilePath;
    }

    public PlatInstance getPlatById(String id) {
        PlatInstance plat = null;
        if (this.plats.containsKey(id)) {
            plat = this.plats.get(id);
        }
        return plat;
    }

    public void init(String _configFile) {
        this.setConfigFile(_configFile);
        this.setConfigFilePath("etc" + GlobalParam.PATH_SEP + this.configFile);
        try {
            this.initPlats();
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Init Plat Instance Manager Error -- Exception : " + ex, 2));
        }
    }

    public int getPlatsNumber() {
        if (this.plats == null) {
            return 0;
        }
        return this.plats.size();
    }

    public void initPlats() throws Exception {
        Document rootDoc = ServerManager.getInstance().getXmlDocFromFile(new File(this.configFilePath));
        Element root = rootDoc.getRootElement();
        Element rootElement = root.getChild("ProvidePlats");
        List<Element> providePlats = rootElement.getChildren();
        for (Element element : providePlats) {
            String id = element.getAttributeValue("id");
            PlatInstance plat = new PlatInstance(id);
            plat.init();
            this.plats.put(id, plat);
        }
    }

    public void postInitProcess() {
        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "PlatInstanceManager initialize successfully", 3));
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void setConfigFilePath(String configFilePath) {
        this.configFilePath = configFilePath;
    }

    private static class ProvidePlatManagerHolder {
        private static final PlatInstanceManager INSTANCE = new PlatInstanceManager();

        private ProvidePlatManagerHolder() {
        }
    }
}

