/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.common.utils.FrameUtils;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.CommonDefines;
import com.simba.server.components.OrderManager;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.SortInfoManager;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.OrderInfo;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.components.data.SortInfo;
import com.simba.server.controllers.luolai.LuolaiCommonParams;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class PlatInstance {
    private static final Logger logger = Logger.getLogger(PlatInstance.class);
    private Channel platClient;
    private final String platId;
    private final ConcurrentHashMap<String, SortInfo> unDefinedSortInfos = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, SortInfo> videoSortInfos = new ConcurrentHashMap();
    private String workerNo;
    private Channel videoChannel = null;
    private final AtomicInteger packetSerialNo = new AtomicInteger(0);
    private static final int MAX_SERIAL_NUMBER = 127;
    private String mode;

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public PlatInstance(String toPlatId) {
        this.platId = toPlatId;
    }

    public Channel getPlatClient() {
        return this.platClient;
    }

    public String getPlatId() {
        return this.platId;
    }

    public String getWorkerNo() {
        return this.workerNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePacketOnCommand(String toPlatId, String seriaPackCode, String carId, String plcId, String platMode, String carFlag, String physicPlatID) {
        SortInfo toDefineSortInfo = null;
        try {
            if (!this.platId.equalsIgnoreCase(toPlatId) || seriaPackCode == null) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handlePacketOnCommand failed this platId=" + this.platId + " toPlatId=" + toPlatId + " seriacode=" + seriaPackCode, 2));
                return;
            }
            if (!this.unDefinedSortInfos.containsKey(seriaPackCode)) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "unDefinedSortInfos not contain seriaOackCode=" + seriaPackCode, 2));
                return;
            }
            toDefineSortInfo = this.unDefinedSortInfos.get(seriaPackCode);
            toDefineSortInfo.setCarId(carId);
            toDefineSortInfo.setPlatMode(platMode);
            toDefineSortInfo.setPlatId(toPlatId);
            toDefineSortInfo.setPlcId(plcId);
            toDefineSortInfo.setPlcPlatID(Integer.parseInt(physicPlatID));
            JSONObject jsonObj = toDefineSortInfo.getDataObj();
            String mode = "none";
            if (jsonObj.has("Mode")) {
                mode = jsonObj.getString("Mode");
            }
            toDefineSortInfo.setTimePacketOn(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
            toDefineSortInfo.setTimestampPacketOn(SorterProtocolCreator.getInstance().createCurrentTimeStamp());
            SortInfoManager.getInstance().addSortInfo(toDefineSortInfo);
            SortControllerManager.getInstance().onPacketOnMessage(toDefineSortInfo);
            this.sendPacketOnInfoToClient(carId, toPlatId, mode, toDefineSortInfo.getOrderInfo().getSkuBarcode());
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle Packet On Message Error -- Exception : " + ex, 2));
        }
        finally {
            if (this.unDefinedSortInfos.containsKey(seriaPackCode)) {
                this.unDefinedSortInfos.remove(seriaPackCode);
            }
        }
    }

    public void handleScannedCommand(Channel toPlatClient, JSONObject dataObj) {
        try {
            String toPlatId = dataObj.getString("platId");
            String barcode = dataObj.getString("barcode");
            String weight = dataObj.getString("weight");
            String platMode = this.getMode();
            if (!this.platId.equalsIgnoreCase(toPlatId) || barcode == null) {
                return;
            }
            if (toPlatClient != null && this.platClient != toPlatClient) {
                this.setPlatClient(toPlatClient);
            }
            SortInfo unDefinedsortInfo = SortInfoManager.getInstance().createSortInfo();
            unDefinedsortInfo.setBarcode(barcode);
            unDefinedsortInfo.getBarcodeList().add(barcode);
            unDefinedsortInfo.setPlatId(toPlatId);
            unDefinedsortInfo.setWeight(weight);
            unDefinedsortInfo.setPlatMode(platMode);
            unDefinedsortInfo.setOrderMode(this.getMode());
            int plcPlatID = Integer.parseInt(toPlatId);
            if (plcPlatID > LuolaiCommonParams.getInstance().getEachLayerPlatNums()) {
                plcPlatID -= LuolaiCommonParams.getInstance().getEachLayerPlatNums();
                unDefinedsortInfo.setLayer(2);
            }
            if (plcPlatID > LuolaiCommonParams.getInstance().getEachLayerPlatNums()) {
                plcPlatID -= LuolaiCommonParams.getInstance().getEachLayerPlatNums();
                unDefinedsortInfo.setLayer(3);
            }
            unDefinedsortInfo.setPlcPlatID(plcPlatID);
            unDefinedsortInfo.setTimeScanned(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
            unDefinedsortInfo.setTimestampScanned(SorterProtocolCreator.getInstance().createCurrentTimeStamp());
            unDefinedsortInfo.setDataObj(dataObj);
            SortControllerManager.getInstance().onScannedMessage(unDefinedsortInfo);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle Scanner Message With Simple Mode Error -- Exception : " + ex, 2));
        }
    }

    public void setPacketSerial(SortInfo unDefinedsortInfo) {
        try {
            int keyInt = this.packetSerialNo.incrementAndGet();
            if (this.packetSerialNo.get() > 127) {
                this.packetSerialNo.set(1);
                keyInt = 1;
            }
            String packetSerial = String.valueOf(keyInt);
            unDefinedsortInfo.setPacketSerialNo(packetSerial);
            this.unDefinedSortInfos.put(packetSerial, unDefinedsortInfo);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "setPacketSerial Error -- Exception : " + ex, 2));
        }
    }

    public void init() {
    }

    public void resetPlat() {
        try {
            this.unDefinedSortInfos.clear();
            this.sendResetMsgToPLC();
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Reset Provide Plat Message Error -- Exception : " + ex, 2));
        }
    }

    public void resetSelf(Channel providePlatClient) {
        if (providePlatClient != null && providePlatClient != this.platClient) {
            this.platClient = providePlatClient;
        }
        this.packetSerialNo.set(0);
        this.unDefinedSortInfos.clear();
        this.sendResetMsgToPLC();
        this.sendAlertNotifyToPlat("endNotify");
    }

    public void setPlatClient(Channel providePlatClient) {
        this.platClient = providePlatClient;
    }

    public void setWorkerNo(String workerNumber) {
        this.workerNo = workerNumber;
    }

    private void sendResetMsgToPLC() {
        Channel[] channels;
        int platIdValue = Integer.parseInt(this.platId);
        byte[] sendContent = SorterProtocolCreator.getInstance().createResetPlatBuffer(platIdValue);
        for (Channel channel : channels = FrameChannelManager.getInstance().getChannelList()) {
            FrameChannelManager.getInstance().commitResponse(channel, sendContent, false);
        }
    }

    public Channel getVideoChannel() {
        return this.videoChannel;
    }

    public void setVideoChannel(Channel videoChannel) {
        this.videoChannel = videoChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleVideoCodingMessage(String toProvidePlatId, String barcode, String carId, String Code1, String Code2, String Code3, String workerNumber) {
        SortInfo toDefineSortInfo = null;
        try {
            if (!this.platId.equalsIgnoreCase(toProvidePlatId) || barcode == null || carId == null) {
                return;
            }
            if (!this.videoSortInfos.containsKey(barcode)) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "videoSortInfos not contain barcode " + barcode, 2));
                return;
            }
            toDefineSortInfo = this.videoSortInfos.get(barcode);
            if (toDefineSortInfo == null) {
                return;
            }
            System.out.println("find sort info:");
            JSONObject jsobj = toDefineSortInfo.getDataObj();
            jsobj.put("Code1", Code1);
            jsobj.put("Code2", Code2);
            jsobj.put("Code3", Code3);
            jsobj.put("workerNumber", workerNumber);
            toDefineSortInfo.setDataObj(jsobj);
            toDefineSortInfo.getSlotsList().clear();
            if (LuolaiCommonParams.getInstance().getStoMode().contains("dep")) {
                this.handleDepartureSortInfo(toDefineSortInfo);
            } else {
                this.handleArrivalVideoTask(toDefineSortInfo);
            }
            this.sendVideoResult(toDefineSortInfo);
            this.sendVideoSortInfoMsgToPlc(toDefineSortInfo);
            this.videoSortInfos.remove(barcode);
            if (this.videoSortInfos.size() > 5000) {
                this.videoSortInfos.clear();
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handleVideoCodingMessage Error -- Exception : " + ex, 2));
        }
        finally {
            if (this.unDefinedSortInfos.containsKey(barcode)) {
                this.unDefinedSortInfos.remove(barcode);
            }
        }
    }

    private boolean handleArrivalVideoTask(SortInfo sortInfo) {
        Boolean res = false;
        try {
            JSONObject dataObj = sortInfo.getDataObj();
            dataObj.put("stoMode", "arrival");
            ICommand command = CommandCreator.getInstance().createCommand("STOSortPlanA", sortInfo);
            res = SQLCommandExecutor.getInstance().executeCmd(command);
            if (res.booleanValue()) {
                System.out.println("handleArrivalVideoTask:success");
                sortInfo.setIsVideoCodingSuccess(1);
            } else {
                System.out.println("handleArrivalVideoTask:failed");
                sortInfo.setIsVideoCodingSuccess(0);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handleArrivalVideoTask Error -- Exception : " + ex, 2));
        }
        return res;
    }

    private boolean handleDepartureSortInfo(SortInfo sortInfo) {
        Boolean res = false;
        try {
            JSONObject dataObj = sortInfo.getDataObj();
            dataObj.put("stoMode", "departure");
            ICommand command = CommandCreator.getInstance().createCommand("STOSortPlanD", sortInfo);
            res = SQLCommandExecutor.getInstance().executeCmd(command);
            if (res.booleanValue()) {
                this.handleNormalSortInfo(sortInfo);
                sortInfo.setIsVideoCodingSuccess(1);
            } else {
                sortInfo.setIsVideoCodingSuccess(0);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handleDepartureSortInfo Error -- Exception : " + ex, 2));
        }
        return res;
    }

    private void handleNormalSortInfo(SortInfo sortInfo) {
    }

    private void sendVideoSortInfoMsgToPlc(SortInfo sortInfo) {
        if (sortInfo == null) {
            return;
        }
    }

    private void sendVideoResult(SortInfo sortInfo) {
        try {
            String barCode = sortInfo.getBarcode();
            JSONObject responseObj = new JSONObject();
            responseObj.put("ServiceName", "SortResult");
            responseObj.put("platId", sortInfo.getPlatId());
            responseObj.put("barcode", barCode);
            String slots = "";
            if (sortInfo.getSlotsList().size() > 0) {
                for (int slot : sortInfo.getSlotsList()) {
                    slots = slots + String.valueOf(slot) + "|";
                }
            }
            if (!slots.equalsIgnoreCase("")) {
                responseObj.put("factualSlot", slots.substring(0, slots.length() - 1));
            } else {
                responseObj.put("factualSlot", "0");
            }
            if (sortInfo.getIsVideoCodingSuccess() > 0) {
                responseObj.put("status", "True");
            } else {
                responseObj.put("status", "False");
            }
            Channel channel = this.getVideoChannel();
            if (channel != null && channel.isConnected()) {
                String sendContent = responseObj.toString();
                JsonChannelManager.getInstance().commitResponse(channel, sendContent.getBytes(), false);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "sendVideoResult catch an exception : " + ex.getMessage(), 2));
        }
    }

    private void sendVideoTask(SortInfo sortInfo) {
        try {
            String barCode = sortInfo.getBarcode();
            JSONObject responseObj = new JSONObject();
            responseObj.put("ServiceName", "VideoCoding");
            responseObj.put("platId", sortInfo.getPlatId());
            responseObj.put("barcode", barCode);
            Channel channel = this.getVideoChannel();
            if (channel != null && channel.isConnected()) {
                Date date = new Date();
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String sendContent = responseObj.toString();
                JsonChannelManager.getInstance().commitResponse(channel, sendContent.getBytes(), false);
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), " send video task to " + channel.getRemoteAddress() + " content is " + sendContent, 1));
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "sendVideoTaskT catch an exception : " + ex.getMessage(), 2));
        }
    }

    private byte[] createVideoSortResultBuffer(SortInfo sortInfo) {
        String plcId = sortInfo.getPlcId();
        int slotNumber = sortInfo.getSlotsList().size();
        byte[] replyBuffer = new byte[21 + 2 * slotNumber + plcId.length()];
        int position = 0;
        byte[] header = CommonDefines.REPLY_HEADER;
        System.arraycopy(header, 0, replyBuffer, position, header.length);
        byte[] command = new byte[]{7};
        System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
        String carId = sortInfo.getCarId();
        byte[] carIdBuf = new byte[2];
        FrameUtils.getInstance().setShortBigEndian(0, Integer.parseInt(carId), carIdBuf);
        System.arraycopy(carIdBuf, 0, replyBuffer, position += command.length, carIdBuf.length);
        byte[] statusAndOBR = new byte[]{0, 1};
        System.arraycopy(statusAndOBR, 0, replyBuffer, position += carIdBuf.length, statusAndOBR.length);
        int slotsSum = slotNumber;
        byte[] slotlen = new byte[]{(byte)slotsSum};
        System.arraycopy(slotlen, 0, replyBuffer, position += statusAndOBR.length, slotlen.length);
        position += slotlen.length;
        for (int i = 0; i < slotsSum; ++i) {
            int yundaslotId = sortInfo.getSlotsList().get(i);
            byte[] slotBuf = new byte[2];
            FrameUtils.getInstance().setShortBigEndian(0, yundaslotId, slotBuf);
            System.arraycopy(slotBuf, 0, replyBuffer, position, slotBuf.length);
            position += slotBuf.length;
        }
        byte[] slotUnusual = new byte[]{0};
        System.arraycopy(slotUnusual, 0, replyBuffer, position, slotUnusual.length);
        byte[] plcidLen = new byte[]{(byte)plcId.length()};
        System.arraycopy(plcidLen, 0, replyBuffer, position += slotUnusual.length, plcidLen.length);
        byte[] plcid = plcId.getBytes();
        System.arraycopy(plcid, 0, replyBuffer, position += plcidLen.length, plcid.length);
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddHHmmss");
        String timeNow = dateFormat.format(new Date());
        byte[] systemTime = timeNow.getBytes();
        System.arraycopy(systemTime, 0, replyBuffer, position += plcid.length, systemTime.length);
        byte[] serialByte = new byte[]{1};
        System.arraycopy(serialByte, 0, replyBuffer, position += systemTime.length, serialByte.length);
        byte[] replayEnder = CommonDefines.REPLY_ENDER;
        System.arraycopy(replayEnder, 0, replyBuffer, position += serialByte.length, replayEnder.length);
        position += replayEnder.length;
        return replyBuffer;
    }

    public void handleVideoRegistCommand(Channel toPlatClient, JSONObject dataObj) {
        try {
            String toPlatId = dataObj.getString("platId");
            if (!this.platId.equalsIgnoreCase(toPlatId)) {
                return;
            }
            if (toPlatClient != null && this.platClient != toPlatClient) {
                this.setPlatClient(toPlatClient);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handleVideoRegistCommand Error -- Exception : " + ex, 2));
        }
    }

    private void sendPacketOnInfoToClient(String carId, String platId, String mode, String skuBarcode) {
        try {
            JSONObject sortInfoObj = new JSONObject();
            sortInfoObj.put("ServiceName", "PacketOnInfo");
            sortInfoObj.put("carId", carId);
            sortInfoObj.put("platId", platId);
            sortInfoObj.put("platMode", mode);
            sortInfoObj.put("barcode", skuBarcode);
            String sortInfoStr = sortInfoObj.toString();
            for (Channel channel : JsonChannelManager.getInstance().getChannelList()) {
                JsonChannelManager.getInstance().commitResponse(channel, sortInfoStr.getBytes(), false);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[PacketOnDecoder.sendPacketOnInfoToClient],[Packet on info send to remote logger error : " + ex.getMessage() + "]", 2));
        }
    }

    public void sendMovePackageToClient(String platId, int seriaNum) {
        try {
            JSONObject sortInfoObj = new JSONObject();
            sortInfoObj.put("ServiceName", "PackageMoved");
            sortInfoObj.put("platId", platId);
            sortInfoObj.put("plcSeriaNum", seriaNum);
            JsonChannelManager.getInstance().commitResponse(this.platClient, sortInfoObj.toString().getBytes(), false);
            SortInfo toDefineSortInfo = this.unDefinedSortInfos.get(String.valueOf(seriaNum));
            if (toDefineSortInfo != null) {
                ICommand command = CommandCreator.getInstance().createCommand("UpdateOrderMoveOn", toDefineSortInfo);
                SQLCommandExecutor.getInstance().executeCmd(command);
                this.removeMoveonLpnSku(toDefineSortInfo);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[sendMovePackageToClient.sendMovePackageToClient],[send to remote logger error : " + ex.getMessage() + "]", 2));
        }
    }

    private void removeMoveonLpnSku(SortInfo sortInfo) {
        OrderInfo orderInfo = sortInfo.getOrderInfo();
        String strKey = orderInfo.getLpn() + "-" + sortInfo.getBarcode();
        if (OrderManager.getInstance().getSkuLpnMoveOnMap().containsKey(strKey)) {
            OrderManager.getInstance().getSkuLpnMoveOnMap().remove(strKey);
        }
    }

    private void sendAlertNotifyToPlat(String status) {
        if (this.platClient == null || !this.platClient.isConnected()) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Send Notification To Plat Error:[Client Disconnect]", 3));
        }
        JSONObject sortInfoObj = new JSONObject();
        sortInfoObj.put("ServiceName", "AlertNotify");
        sortInfoObj.put("platId", this.getPlatId());
        sortInfoObj.put("status", status);
        String sortInfoContent = sortInfoObj.toString();
        JsonChannelManager.getInstance().commitResponse(this.platClient, sortInfoContent.getBytes(), false);
        if (status.equals("startNotify")) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Start Send Alert Notification To Plat:[" + this.platId + "]", 3));
        }
    }

    public void handleDelOrder(Channel toPlatClient, JSONObject dataObj) {
        try {
            String toPlatId = dataObj.getString("platId");
            String barcode = dataObj.getString("barcode");
            String platMode = this.getMode();
            if (!this.platId.equalsIgnoreCase(toPlatId) || barcode == null) {
                return;
            }
            if (toPlatClient != null && this.platClient != toPlatClient) {
                this.setPlatClient(toPlatClient);
            }
            SortInfo unDefinedsortInfo = SortInfoManager.getInstance().createSortInfo();
            unDefinedsortInfo.setBarcode(barcode);
            unDefinedsortInfo.getBarcodeList().add(barcode);
            unDefinedsortInfo.setPlatId(toPlatId);
            unDefinedsortInfo.setPlatMode(platMode);
            unDefinedsortInfo.setOrderMode(this.getMode());
            unDefinedsortInfo.setTimeScanned(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
            unDefinedsortInfo.setTimestampScanned(SorterProtocolCreator.getInstance().createCurrentTimeStamp());
            unDefinedsortInfo.setDataObj(dataObj);
            boolean isFindDelSku = false;
            if (OrderManager.getInstance().getSkuDelCount().containsKey(unDefinedsortInfo.getBarcode())) {
                isFindDelSku = true;
            } else {
                ICommand command = CommandCreator.getInstance().createCommand("FetchDelOrderInfoD", unDefinedsortInfo);
                Boolean res = SQLCommandExecutor.getInstance().executeCmd(command);
                if (res.booleanValue()) {
                    isFindDelSku = true;
                    OrderManager.getInstance().getSkuDelCount().put(barcode, unDefinedsortInfo.getOrderInfo().getSkuQty());
                    this.handleTrashSlotPrint(unDefinedsortInfo);
                }
            }
            if (OrderManager.getInstance().getSkuDelCount().containsKey(barcode)) {
                int skuQty = OrderManager.getInstance().getSkuDelCount().get(barcode) - 1;
                if (skuQty <= 0) {
                    OrderManager.getInstance().getSkuDelCount().remove(barcode);
                } else {
                    OrderManager.getInstance().getSkuDelCount().put(barcode, skuQty);
                }
            }
            this.handleDelResultToClient(toPlatClient, isFindDelSku);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle del barcode Message With Simple Mode Error -- Exception : " + ex, 2));
        }
    }

    private void handleDelResultToClient(Channel toPlatClient, boolean isFindDelSku) {
        try {
            JSONObject contentObj = new JSONObject();
            contentObj.put("ServiceName", "AckDelBarcode");
            if (isFindDelSku) {
                contentObj.put("Result", "success");
            } else {
                contentObj.put("Result", "fail");
            }
            String requestContent = contentObj.toString();
            JsonChannelManager.getInstance().commitResponse(toPlatClient, requestContent.getBytes(), false);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handleDelResultToClient Error -- Exception : " + ex, 2));
        }
    }

    private void handleTrashSlotPrint(SortInfo unDefinedsortInfo) {
        try {
            SlotInfo slotInfo = new SlotInfo();
            List<String> noPlanSlots = SlotManager.getInstance().getNoPlanTrashSlots();
            for (String trashSlot : noPlanSlots) {
                slotInfo.setSlotId(trashSlot);
            }
            slotInfo.setLpn(unDefinedsortInfo.getOrderInfo().getLpn());
            slotInfo.setLpnQty(unDefinedsortInfo.getOrderInfo().getLpnQty());
            slotInfo.setMailCount(0);
            slotInfo.getSkuMap().put(unDefinedsortInfo.getOrderInfo().getSkuBarcode(), unDefinedsortInfo.getOrderInfo());
            OrderManager.getInstance().sendOrderFinishToWms(slotInfo);
            ICommand command = CommandCreator.getInstance().createCommand("UpdateOrderBigsize", unDefinedsortInfo);
            Boolean res = SQLCommandExecutor.getInstance().executeCmd(command);
            if (!res.booleanValue()) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "update bigsize filed lpn= : " + unDefinedsortInfo.getOrderInfo().getLpn(), 2));
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handleTrashSlotPrint Error -- Exception : " + ex, 2));
        }
    }
}

