/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.DeleteData;
import com.simba.server.components.data.LpnInfo;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.components.data.UploadInfo;
import com.simba.server.netclient.DefaultClientManager;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.json.JSONException;
import org.json.JSONObject;

public class OrderManager {
    private static final Logger logger = Logger.getLogger(OrderManager.class);
    private ConcurrentHashMap<String, LpnInfo> skuLpnScanMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, LpnInfo> skuLpnMoveOnMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, LpnInfo> skuLpnPackOnMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Timestamp> taskLpnSkuMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Integer> skuDelCount = new ConcurrentHashMap();
    private List<DeleteData> delDataList = new LinkedList<DeleteData>();
    public Timestamp timestamp;

    public List<DeleteData> getDelDataList() {
        return this.delDataList;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public void setDelDataList(List<DeleteData> delDataList) {
        this.delDataList = delDataList;
    }

    public static OrderManager getInstance() {
        return OrderManagerHolder.INSTANCE;
    }

    public ConcurrentHashMap<String, LpnInfo> getPackOnSkuLpnMap() {
        return this.skuLpnPackOnMap;
    }

    public void handleRecOrderInfo(JSONObject jsonObject) {
        try {
            if (jsonObject == null) {
                return;
            }
        }
        catch (JSONException ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handleRecOrderInfo Error : exception info : ", 2));
        }
    }

    public void handleRecOrderCheck(JSONObject jsonObject) {
        try {
            if (jsonObject == null) {
                return;
            }
        }
        catch (JSONException ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handleRecOrderInfo Error : exception info : ", 2));
        }
    }

    public void handleLpnFinish(SlotInfo slotInfo) {
        try {
            if (slotInfo == null) {
                return;
            }
            if (!SlotManager.getInstance().checkSlotIsTrash(slotInfo.getSlotId()).booleanValue()) {
                if (!slotInfo.isDeleteOrder()) {
                    OrderManager.getInstance().removeLpn(slotInfo);
                    slotInfo.setDeleteOrder(true);
                }
                this.senSlotLightoPlc(slotInfo);
                this.sendOrderFinishToWms(slotInfo);
                this.updateLpnSlotStatus(slotInfo);
            }
            if (slotInfo.getMailCount() > 1000) {
                slotInfo.setMailCount(0);
            }
            this.resetSlot(slotInfo);
        }
        catch (JSONException ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handleLpnFinish Error : exception info : ", 2));
        }
    }

    private void resetSlot(SlotInfo slotInfo) {
        slotInfo.setLpn("");
        slotInfo.setMailCount(0);
        slotInfo.setPackCode("");
        slotInfo.setTotalWeight(0.0);
        slotInfo.setLpnQty(0);
        slotInfo.setOpID(0L);
        slotInfo.setUploadStatus(0);
        slotInfo.getSkuMap().clear();
        slotInfo.setDeleteOrder(false);
    }

    public void senSlotLightoPlc(SlotInfo slotInfo) {
        Channel[] clients;
        byte[] replyBuffer = SorterProtocolCreator.getInstance().createSlotLightBuffer(slotInfo);
        for (Channel client : clients = FrameChannelManager.getInstance().getChannelList()) {
            FrameChannelManager.getInstance().commitResponse(client, replyBuffer, false);
        }
    }

    public void sendOrderFinishToWms(SlotInfo slotInfo) {
        String strOrderFinishContents = SorterProtocolCreator.getInstance().createOrderFinishMsg(slotInfo);
        byte[] content = strOrderFinishContents.getBytes();
        boolean res = DefaultClientManager.getInstance().sendUploadMsgToStoClient(content);
        if (res) {
            slotInfo.setUploadStatus(1);
        } else {
            slotInfo.setUploadStatus(0);
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "sendOrderFinishToWms failed : " + strOrderFinishContents, 2));
        }
        UploadInfo uploadInfo = new UploadInfo();
        uploadInfo.setContent(strOrderFinishContents);
        uploadInfo.setUploadStatus(slotInfo.getUploadStatus());
        uploadInfo.setLpn(slotInfo.getLpn());
        this.restoreLpnUploadStatus(uploadInfo);
    }

    private void restoreLpnUploadStatus(UploadInfo uploadInfo) {
        ICommand command = CommandCreator.getInstance().createCommand("AddLpnUploadStatus", uploadInfo);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }

    private void updateLpnSlotStatus(SlotInfo slotInfo) {
        ICommand command = CommandCreator.getInstance().createCommand("UpdateLpnStatus", slotInfo);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }

    public void removeLpn(SlotInfo slotInfo) {
        ICommand command = CommandCreator.getInstance().createCommand("RemoveOrderLpn", slotInfo);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }

    public ConcurrentHashMap<String, LpnInfo> getSkuLpnMoveOnMap() {
        return this.skuLpnMoveOnMap;
    }

    public void setSkuLpnMoveOnMap(ConcurrentHashMap<String, LpnInfo> skuLpnMoveOnMap) {
        this.skuLpnMoveOnMap = skuLpnMoveOnMap;
    }

    public ConcurrentHashMap<String, LpnInfo> getSkuLpnScanMap() {
        return this.skuLpnScanMap;
    }

    public void setSkuLpnScanMap(ConcurrentHashMap<String, LpnInfo> skuLpnScanMap) {
        this.skuLpnScanMap = skuLpnScanMap;
    }

    public void responseAck(Channel channel) {
        try {
            ChannelFuture writeFuture = null;
            String strAck = "ACK#";
            byte[] msg = strAck.getBytes();
            int limit = msg.length;
            ByteBuffer returnBuffer = ByteBuffer.allocate(limit);
            returnBuffer.put(msg, 0, limit);
            returnBuffer.rewind();
            ChannelBuffer duplicateBuffer = ChannelBuffers.wrappedBuffer(returnBuffer);
            writeFuture = channel.write(duplicateBuffer);
        }
        catch (JSONException ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "responseAck  Error : exception info : ", 2));
        }
    }

    public ConcurrentHashMap<String, Timestamp> getTaskLpnSkuMap() {
        return this.taskLpnSkuMap;
    }

    public void setTaskLpnSkuMap(ConcurrentHashMap<String, Timestamp> taskLpnSkuMap) {
        this.taskLpnSkuMap = taskLpnSkuMap;
    }

    public ConcurrentHashMap<String, Integer> getSkuDelCount() {
        return this.skuDelCount;
    }

    public void setSkuDelCount(ConcurrentHashMap<String, Integer> skuDelCount) {
        this.skuDelCount = skuDelCount;
    }

    private static class OrderManagerHolder {
        private static final OrderManager INSTANCE = new OrderManager();

        private OrderManagerHolder() {
        }
    }
}

