/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.SlotInfo;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class UpdateSlotStatusCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(UpdateSlotStatusCmd.class);
    private final SlotInfo slotInfo;

    public UpdateSlotStatusCmd(SlotInfo slotInfo) {
        this.slotInfo = slotInfo;
    }

    @Override
    public String getName() {
        return "UpdateSlotStatus";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        DbOperator dbOperator = (DbOperator)params;
        String strInsertSql = "update  tt_slot_status set mode=?,qty=?,actQty=?,firstPacketOffTime=?,isLock=?,isOpen=?,isElectricFull=? where slot=?";
        try {
            dbOperator.clearParameters();
            dbOperator.prepareStatement(strInsertSql);
            dbOperator.setString(1, this.slotInfo.getSortInfoMode());
            dbOperator.setInt(2, this.slotInfo.getLpnQty());
            dbOperator.setInt(3, this.slotInfo.getMailCount());
            Timestamp ts = this.slotInfo.getBeginTime();
            if (ts == null) {
                ts = SorterProtocolCreator.getInstance().createCurrentTimeStamp();
            }
            dbOperator.setTimestamp(4, ts);
            dbOperator.setInt(5, this.slotInfo.getIsLocked());
            dbOperator.setInt(6, this.slotInfo.getIsOpen());
            dbOperator.setInt(7, this.slotInfo.getIsShadow());
            dbOperator.setInt(8, Integer.parseInt(this.slotInfo.getSlotId()));
            int rs = dbOperator.executeUpdate();
            if (rs > 0) {
                ret = true;
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when UpdateSlotStatusCmd : " + ex.getMessage(), 2));
            ret = false;
        }
        return ret;
    }
}

